/*
 * Decompiled with CFR 0.152.
 */
package adams.data.textrenderer;

import adams.data.textrenderer.AbstractTextRenderer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import net.minidev.json.JSONAware;
import nz.ac.waikato.cms.locator.ClassLocator;

public class JsonTextRenderer
extends AbstractTextRenderer {
    private static final long serialVersionUID = 4610900500263644291L;

    public String globalInfo() {
        return "Renders JSON objects.";
    }

    public boolean handles(Object obj) {
        return obj != null && this.handles(obj.getClass());
    }

    public boolean handles(Class cls) {
        return ClassLocator.matches(JSONAware.class, (Class)cls) || ClassLocator.matches(JsonElement.class, (Class)cls);
    }

    protected String doRender(Object obj) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        JsonParser jp = new JsonParser();
        JsonElement je = jp.parse(obj.toString());
        String result = gson.toJson(je);
        return result;
    }
}

