/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;

public class JsonFileReader
extends AbstractTransformer {
    private static final long serialVersionUID = -184602726110144511L;
    protected OutputType m_Type;

    public String globalInfo() {
        return "Reads a JSON file and forwards the parsed JSON object.\nIf it is know beforehand, whether the JSON file contains an object or an array, the output type can be specified.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)OutputType.ANY);
    }

    public void setType(OutputType value) {
        this.m_Type = value;
        this.reset();
    }

    public OutputType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of the output to enforce.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)((Object)this.m_Type));
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    public Class[] generates() {
        switch (this.m_Type) {
            case ANY: {
                return new Class[]{JSONAware.class};
            }
            case ARRAY: {
                return new Class[]{JSONArray.class};
            }
            case OBJECT: {
                return new Class[]{JSONObject.class};
            }
        }
        throw new IllegalStateException("Unhandled output type: " + (Object)((Object)this.m_Type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected String doExecute() {
        result = null;
        fileObj = this.m_InputToken.getPayload();
        file = fileObj instanceof File != false ? (File)fileObj : new PlaceholderFile((String)fileObj);
        freader = null;
        breader = null;
        try {
            freader = new FileReader(file.getAbsolutePath());
            breader = new BufferedReader(freader);
            parser = new JSONParser(1984);
            obj = parser.parse((Reader)breader);
            switch (1.$SwitchMap$adams$flow$transformer$JsonFileReader$OutputType[this.m_Type.ordinal()]) {
                case 1: {
                    this.m_OutputToken = new Token(obj);
                    ** break;
                }
                case 2: {
                    this.m_OutputToken = new Token((Object)((JSONArray)obj));
                    ** break;
                }
                case 3: {
                    this.m_OutputToken = new Token((Object)((JSONObject)obj));
                    ** break;
                }
                default: {
                    throw new IllegalStateException("Unhandled output type: " + (Object)this.m_Type);
lbl23:
                    // 3 sources

                    break;
                }
            }
        }
        catch (Exception e) {
            try {
                result = this.handleException("Failed to read JSON file: " + file, e);
            }
            catch (Throwable var9_9) {
                FileUtils.closeQuietly(breader);
                FileUtils.closeQuietly((Reader)freader);
                throw var9_9;
            }
            FileUtils.closeQuietly((Reader)breader);
            FileUtils.closeQuietly((Reader)freader);
        }
        FileUtils.closeQuietly((Reader)breader);
        FileUtils.closeQuietly((Reader)freader);
        return result;
    }

    public static enum OutputType {
        ANY,
        OBJECT,
        ARRAY;

    }
}

