/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core.json;

import adams.gui.core.GUIHelper;
import adams.gui.core.json.JsonNode;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;

public class JsonRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = -3242391430220560720L;
    protected Icon m_IconObject;
    protected Icon m_IconArray;
    protected Icon m_IconOther;
    protected Icon m_IconNum;
    protected Icon m_IconStr;
    protected Icon m_IconBool;

    public JsonRenderer() {
        this.initialize();
    }

    protected void initialize() {
        this.m_IconObject = GUIHelper.getIcon((String)"object.gif");
        this.m_IconArray = GUIHelper.getIcon((String)"brackets.gif");
        this.m_IconOther = GUIHelper.getEmptyIcon();
        this.m_IconNum = GUIHelper.getIcon((String)"json_number.gif");
        this.m_IconStr = GUIHelper.getIcon((String)"json_string.gif");
        this.m_IconBool = GUIHelper.getIcon((String)"json_boolean.gif");
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        if (value instanceof JsonNode) {
            JsonNode node = (JsonNode)((Object)value);
            Icon icon = null;
            icon = node.getValue() instanceof JSONObject ? this.m_IconObject : (node.getValue() instanceof JSONArray ? this.m_IconArray : (node.getValue() instanceof String ? this.m_IconStr : (node.getValue() instanceof Number ? this.m_IconNum : (node.getValue() instanceof Boolean ? this.m_IconBool : this.m_IconOther))));
            this.setIcon(icon);
            this.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
        }
        return this;
    }
}

