/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.gui.core.TextEditorPanel;
import adams.gui.tools.previewbrowser.AbstractContentHandler;
import adams.gui.tools.previewbrowser.PreviewPanel;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import javax.swing.JComponent;

public class JsonPrettyPrintHandler
extends AbstractContentHandler {
    private static final long serialVersionUID = -5643331918040646266L;

    public String globalInfo() {
        return "Displays JSON files in pretty print format: " + Utils.arrayToString((Object)this.getExtensions());
    }

    public String[] getExtensions() {
        return new String[]{"json"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PreviewPanel createPreview(File file) {
        PreviewPanel result;
        FileReader freader = null;
        BufferedReader breader = null;
        try {
            freader = new FileReader(file.getAbsolutePath());
            breader = new BufferedReader(freader);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            JsonParser jp = new JsonParser();
            JsonElement je = jp.parse((Reader)breader);
            String content = gson.toJson(je);
            TextEditorPanel textPanel = new TextEditorPanel();
            textPanel.setContent(content);
            textPanel.setEditable(false);
            result = new PreviewPanel((JComponent)textPanel, (JComponent)textPanel.getTextArea());
        }
        catch (Exception e) {
            try {
                TextEditorPanel textPanel = new TextEditorPanel();
                textPanel.open(file);
                textPanel.setEditable(false);
                result = new PreviewPanel((JComponent)textPanel, (JComponent)textPanel.getTextArea());
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(breader);
                FileUtils.closeQuietly((Reader)freader);
                throw throwable;
            }
            FileUtils.closeQuietly((Reader)breader);
            FileUtils.closeQuietly((Reader)freader);
        }
        FileUtils.closeQuietly((Reader)breader);
        FileUtils.closeQuietly((Reader)freader);
        return result;
    }
}

