/*
 * Decompiled with CFR 0.152.
 */
package adams.scripting.processor;

import adams.core.MessageCollection;
import adams.core.Properties;
import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.io.GzipUtils;
import adams.core.io.PrettyPrintingSupporter;
import adams.core.option.OptionUtils;
import adams.scripting.command.RemoteCommand;
import adams.scripting.command.RemoteCommandWithResponse;
import adams.scripting.processor.AbstractRemoteCommandProcessor;
import adams.scripting.processor.RemoteCommandProcessor;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.Base64;
import java.util.List;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;

public class JsonProcessor
extends AbstractRemoteCommandProcessor
implements PrettyPrintingSupporter {
    private static final long serialVersionUID = -7804545376269832263L;
    public static final String MESSAGE_CHARSET = "UTF-8";
    protected boolean m_PrettyPrinting;

    public String globalInfo() {
        return "Uses JSON for processing remote commands.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("pretty-printing", "prettyPrinting", (Object)false);
    }

    public void setPrettyPrinting(boolean value) {
        this.m_PrettyPrinting = value;
        this.reset();
    }

    public boolean getPrettyPrinting() {
        return this.m_PrettyPrinting;
    }

    public String prettyPrintingTipText() {
        return "If enabled, the JSON message are pretty-printed rather than optimized for size.";
    }

    public RemoteCommand parse(String data, MessageCollection errors) {
        RemoteCommand result;
        JSONObject json;
        try {
            json = (JSONObject)new JSONParser(1984).parse(data);
        }
        catch (Exception e) {
            errors.add("Failed to parse: " + data, (Throwable)e);
            return null;
        }
        byte[] payload = new byte[]{};
        if (json.containsKey((Object)"payload")) {
            payload = Base64.getDecoder().decode(json.getAsString("payload"));
        }
        if (payload.length > 0 && (payload = GzipUtils.decompress((byte[])payload, (int)1024)) == null) {
            errors.add("Failed to decompress payload!");
            payload = new byte[]{};
        }
        if (!json.containsKey((Object)"header")) {
            errors.add("Header missing!");
            return null;
        }
        JSONObject header = (JSONObject)json.get((Object)"header");
        String cmd = header.getAsString("Command");
        if (cmd == null || cmd.isEmpty()) {
            errors.add("No command present in content, failed to parse!");
            return null;
        }
        Properties props = new Properties();
        for (String key : header.keySet()) {
            props.setProperty(key, header.getAsString(key));
        }
        try {
            result = (RemoteCommand)OptionUtils.forCommandLine(RemoteCommand.class, (String)cmd);
            result.parse(props);
            if (result.isRequest()) {
                result.setRequestPayload(payload);
            } else if (result instanceof RemoteCommandWithResponse) {
                ((RemoteCommandWithResponse)result).setResponsePayload(payload);
            } else {
                errors.add("Command flagged as response but does not implement " + RemoteCommandWithResponse.class.getName() + ": " + cmd);
            }
        }
        catch (Exception e) {
            errors.add("Failed to instantiate commandline: " + cmd, (Throwable)e);
            result = null;
        }
        return result;
    }

    public String format(Properties header, byte[] payload) {
        String data = payload.length == 0 ? "" : Base64.getEncoder().encodeToString(payload);
        JsonObject objHeader = new JsonObject();
        for (String key : header.keySetAll()) {
            objHeader.addProperty(key, header.getProperty(key));
        }
        JsonObject result = new JsonObject();
        result.add("header", (JsonElement)objHeader);
        result.addProperty("payload", data);
        if (this.m_PrettyPrinting) {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            return gson.toJson((JsonElement)result);
        }
        return result.toString();
    }

    public RemoteCommand read(File file, MessageCollection errors) {
        RemoteCommand cmd = null;
        String data = null;
        List lines = FileUtils.loadFromFile((File)file, (String)MESSAGE_CHARSET);
        if (lines == null) {
            errors.add("Failed to read data from remote command file: " + file);
        } else {
            data = Utils.flatten((List)lines, (String)"\n");
        }
        if (data != null && (cmd = this.parse(data, errors)) == null) {
            errors.add("Failed to parse remote command from data:\n" + data);
        }
        return cmd;
    }

    public boolean write(RemoteCommand cmd, File file, MessageCollection errors) {
        String msg;
        String data = null;
        if (cmd.isRequest()) {
            data = cmd.assembleRequest((RemoteCommandProcessor)this);
        } else if (cmd instanceof RemoteCommandWithResponse) {
            data = ((RemoteCommandWithResponse)cmd).assembleResponse((RemoteCommandProcessor)this);
        } else {
            errors.add("Remote command is not a response but flagged as such:\n" + cmd.toString());
        }
        if (errors.isEmpty() && (msg = FileUtils.writeToFileMsg((String)file.getAbsolutePath(), (Object)data, (boolean)false, (String)MESSAGE_CHARSET)) != null) {
            errors.add(msg);
        }
        return errors.isEmpty();
    }
}

