/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.io.PlaceholderFile;
import adams.core.logging.LoggingLevel;
import adams.core.option.AbstractOptionProducerTestCase;
import adams.core.option.JsonProducer;
import adams.core.option.OptionHandler;
import adams.data.baseline.AbstractBaselineCorrection;
import adams.data.baseline.SlidingWindow;
import adams.data.filter.BaselineCorrection;
import adams.data.filter.Filter;
import adams.data.filter.MultiFilter;
import adams.data.filter.PassThrough;
import adams.env.Environment;
import adams.flow.sink.DumpFile;
import junit.framework.Test;
import junit.framework.TestSuite;

public class JsonProducerTest
extends AbstractOptionProducerTestCase {
    public JsonProducerTest(String name) {
        super(name);
    }

    public void testSimple() {
        DumpFile handler = new DumpFile();
        handler.setLoggingLevel(LoggingLevel.INFO);
        handler.setOutputFile(new PlaceholderFile("${TMP}/dumpfile.arff"));
        handler.setAppend(true);
        JsonProducer producer = new JsonProducer();
        producer.produce((OptionHandler)handler);
        JsonProducerTest.assertEquals((String)"getOutput() differs", (String)"{\"numAttempts\":1,\"stopFlowOnError\":false,\"silent\":false,\"attemptInterval\":1000,\"annotations\":\"\",\"skip\":false,\"encoding\":\"Default\",\"outputFile\":\"${TMP}\\/dumpfile.arff\",\"name\":\"DumpFile\",\"class\":\"adams.flow.sink.DumpFile\",\"loggingLevel\":\"INFO\",\"append\":true,\"bufferSize\":1}", (String)("" + producer.getOutput()));
        JsonProducerTest.assertEquals((String)"toString() differs", (String)"{\"numAttempts\":1,\"stopFlowOnError\":false,\"silent\":false,\"attemptInterval\":1000,\"annotations\":\"\",\"skip\":false,\"encoding\":\"Default\",\"outputFile\":\"${TMP}\\/dumpfile.arff\",\"name\":\"DumpFile\",\"class\":\"adams.flow.sink.DumpFile\",\"loggingLevel\":\"INFO\",\"append\":true,\"bufferSize\":1}", (String)producer.toString());
    }

    public void testDeep() {
        MultiFilter handler = new MultiFilter();
        handler.setLoggingLevel(LoggingLevel.INFO);
        Filter[] filters = new Filter[2];
        filters[0] = new PassThrough();
        filters[0].setLoggingLevel(LoggingLevel.FINE);
        filters[1] = new MultiFilter();
        filters[1].setLoggingLevel(LoggingLevel.FINEST);
        handler.setSubFilters(filters);
        JsonProducer producer = new JsonProducer();
        producer.produce((OptionHandler)handler);
        JsonProducerTest.assertEquals((String)"getOutput() differs", (String)"{\"dontUpdateID\":false,\"subFilters\":[{\"dontUpdateID\":false,\"class\":\"adams.data.filter.PassThrough\",\"loggingLevel\":\"FINE\"},{\"dontUpdateID\":false,\"subFilters\":[{\"dontUpdateID\":false,\"class\":\"adams.data.filter.PassThrough\",\"loggingLevel\":\"WARNING\"}],\"class\":\"adams.data.filter.MultiFilter\",\"loggingLevel\":\"FINEST\"}],\"class\":\"adams.data.filter.MultiFilter\",\"loggingLevel\":\"INFO\"}", (String)("" + producer.getOutput()));
        JsonProducerTest.assertEquals((String)"toString() differs", (String)"{\"dontUpdateID\":false,\"subFilters\":[{\"dontUpdateID\":false,\"class\":\"adams.data.filter.PassThrough\",\"loggingLevel\":\"FINE\"},{\"dontUpdateID\":false,\"subFilters\":[{\"dontUpdateID\":false,\"class\":\"adams.data.filter.PassThrough\",\"loggingLevel\":\"WARNING\"}],\"class\":\"adams.data.filter.MultiFilter\",\"loggingLevel\":\"FINEST\"}],\"class\":\"adams.data.filter.MultiFilter\",\"loggingLevel\":\"INFO\"}", (String)producer.toString());
    }

    public void testDeep2() {
        BaselineCorrection handler = new BaselineCorrection();
        SlidingWindow baseline = new SlidingWindow();
        baseline.setLoggingLevel(LoggingLevel.FINE);
        handler.setBaselineCorrection((AbstractBaselineCorrection)baseline);
        JsonProducer producer = new JsonProducer();
        producer.produce((OptionHandler)handler);
        JsonProducerTest.assertEquals((String)"getOutput() differs", (String)"{\"dontUpdateID\":false,\"baselineCorrection\":{\"numLeft\":30,\"numRight\":30,\"baselineCorrection\":{\"class\":\"adams.data.baseline.PassThrough\",\"loggingLevel\":\"WARNING\"},\"class\":\"adams.data.baseline.SlidingWindow\",\"loggingLevel\":\"FINE\"},\"class\":\"adams.data.filter.BaselineCorrection\",\"loggingLevel\":\"WARNING\"}", (String)("" + producer.getOutput()));
        JsonProducerTest.assertEquals((String)"toString() differs", (String)"{\"dontUpdateID\":false,\"baselineCorrection\":{\"numLeft\":30,\"numRight\":30,\"baselineCorrection\":{\"class\":\"adams.data.baseline.PassThrough\",\"loggingLevel\":\"WARNING\"},\"class\":\"adams.data.baseline.SlidingWindow\",\"loggingLevel\":\"FINE\"},\"class\":\"adams.data.filter.BaselineCorrection\",\"loggingLevel\":\"WARNING\"}", (String)producer.toString());
    }

    public static Test suite() {
        return new TestSuite(JsonProducerTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        JsonProducerTest.runTest((Test)JsonProducerTest.suite());
    }
}

