/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.io.PrettyPrintingSupporter;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractConversion;
import adams.data.report.Report;
import adams.data.report.ReportJsonUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class ReportToJson
extends AbstractConversion
implements PrettyPrintingSupporter {
    private static final long serialVersionUID = 2957342595369694174L;
    protected boolean m_PrettyPrinting;

    public String globalInfo() {
        return "Turns a report into a JSON string.\nOutput format:\n" + ReportJsonUtils.example();
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("pretty-printing", "prettyPrinting", (Object)false);
    }

    public void setPrettyPrinting(boolean value) {
        this.m_PrettyPrinting = value;
        this.reset();
    }

    public boolean getPrettyPrinting() {
        return this.m_PrettyPrinting;
    }

    public String prettyPrintingTipText() {
        return "If enabled, the output is printed in a 'pretty' format.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"prettyPrinting", (boolean)this.m_PrettyPrinting, (String)"pretty-printing");
    }

    public Class accepts() {
        return Report.class;
    }

    public Class generates() {
        return String.class;
    }

    protected Object doConvert() throws Exception {
        JsonObject jobj = ReportJsonUtils.toJson((Report)this.m_Input);
        GsonBuilder builder = new GsonBuilder();
        if (this.m_PrettyPrinting) {
            builder.setPrettyPrinting();
        }
        Gson gson = builder.create();
        return gson.toJson((JsonElement)jobj);
    }
}

