/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.io.FileUtils;
import adams.core.io.PrettyPrintingSupporter;
import adams.data.json.JsonHelper;
import adams.flow.sink.AbstractFileWriter;
import net.minidev.json.JSONAware;

public class JsonFileWriter
extends AbstractFileWriter
implements PrettyPrintingSupporter {
    private static final long serialVersionUID = 3613018887562327088L;
    protected boolean m_PrettyPrinting;

    public String globalInfo() {
        return "Writes a JSON object/array to a file.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("pretty-printing", "prettyPrinting", (Object)false);
    }

    public String outputFileTipText() {
        return "The name of the output file.";
    }

    public void setPrettyPrinting(boolean value) {
        this.m_PrettyPrinting = value;
        this.reset();
    }

    public boolean getPrettyPrinting() {
        return this.m_PrettyPrinting;
    }

    public String prettyPrintingTipText() {
        return "If enabled, the output is printed in a 'pretty' format.";
    }

    public Class[] accepts() {
        return new Class[]{JSONAware.class};
    }

    protected String doExecute() {
        String result = null;
        String content = ((JSONAware)this.m_InputToken.getPayload()).toJSONString();
        if (this.m_PrettyPrinting) {
            content = JsonHelper.prettyPrint(content);
        }
        if (!FileUtils.writeToFile((String)this.m_OutputFile.getAbsolutePath(), (Object)content, (boolean)false)) {
            result = "Failed to write JSON file: " + this.m_OutputFile;
        }
        return result;
    }
}

