/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.logging.LoggingSupporter;
import adams.core.option.OptionHandler;
import adams.data.json.JsonHelper;
import adams.flow.transformer.AbstractArrayProvider;
import java.util.ArrayList;
import java.util.Collections;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONObject;

public class GetJsonKeys
extends AbstractArrayProvider {
    private static final long serialVersionUID = -8757919765508522198L;
    protected boolean m_SortKeys;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("sort-keys", "sortKeys", (Object)false);
    }

    public String globalInfo() {
        return "Outputs all the keys of the JSON Object passing through.";
    }

    public String outputArrayTipText() {
        return "If enabled, the keys will get output as array rather than one-by-one.";
    }

    public void setSortKeys(boolean value) {
        this.m_SortKeys = value;
        this.reset();
    }

    public boolean getSortKeys() {
        return this.m_SortKeys;
    }

    public String sortKeysTipText() {
        return "If enabled, the keys will get sorted.";
    }

    public String getQuickInfo() {
        ArrayList options = new ArrayList();
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"outputArray", (Object)(this.getOutputArray() ? "array" : "one-by-one")));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"sortKeys", (boolean)this.m_SortKeys, (String)"sort keys"));
        String result = QuickInfoHelper.flatten(options);
        return result;
    }

    public Class[] accepts() {
        return new Class[]{JSONAware.class, JSONObject.class, String.class};
    }

    protected Class getItemClass() {
        return String.class;
    }

    protected String doExecute() {
        Object obj;
        String result = null;
        JSONObject json = null;
        if (this.m_InputToken.hasPayload(String.class)) {
            obj = JsonHelper.parse((String)this.m_InputToken.getPayload(String.class), (LoggingSupporter)this);
            if (obj == null) {
                result = "Failed to parse JSON string: " + (String)this.m_InputToken.getPayload(String.class);
            }
        } else {
            obj = this.m_InputToken.getPayload();
        }
        if (!(obj instanceof JSONObject)) {
            result = "Input is not of type " + JSONObject.class.getName() + "!";
        } else {
            json = (JSONObject)this.m_InputToken.getPayload();
        }
        if (result == null) {
            this.m_Queue.addAll(json.keySet());
            if (this.m_SortKeys) {
                Collections.sort(this.m_Queue);
            }
        }
        return result;
    }
}

