/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.base.JsonPathExpression;
import adams.core.logging.LoggingSupporter;
import adams.core.option.OptionHandler;
import adams.data.conversion.Conversion;
import adams.data.conversion.ObjectToObject;
import adams.data.json.JsonHelper;
import adams.flow.control.StorageName;
import adams.flow.control.StorageUser;
import adams.flow.core.Actor;
import adams.flow.core.CallableActorHelper;
import adams.flow.core.CallableActorReference;
import adams.flow.core.OutputProducer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import net.minidev.json.JSONObject;

public class SetJsonValue
extends AbstractTransformer
implements StorageUser {
    private static final long serialVersionUID = -5937471470417243026L;
    protected JsonPathExpression m_Path;
    protected String m_Value;
    protected SourceType m_Type;
    protected CallableActorReference m_Source;
    protected StorageName m_Storage;
    protected CallableActorHelper m_Helper;
    protected Actor m_SourceActor;
    protected Conversion m_Conversion;
    protected transient JsonPath m_ActualPath;
    protected transient boolean m_PathCompiled;

    public String globalInfo() {
        return "Sets a value in a JSON object, using the specified path.\nThe value can be either supplied as string using the 'value' property, obtained from a callable actor (property 'source') or from a storage item (property 'storage').";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("path", "path", (Object)new JsonPathExpression());
        this.m_OptionManager.add("value", "value", (Object)"");
        this.m_OptionManager.add("type", "type", (Object)SourceType.VALUE);
        this.m_OptionManager.add("source", "source", (Object)new CallableActorReference("unknown"));
        this.m_OptionManager.add("storage", "storage", (Object)new StorageName());
        this.m_OptionManager.add("conversion", "conversion", (Object)new ObjectToObject());
    }

    protected void initialize() {
        super.initialize();
        this.m_Helper = new CallableActorHelper();
    }

    protected void reset() {
        super.reset();
        this.m_SourceActor = null;
    }

    public void setPath(JsonPathExpression value) {
        this.m_Path = value;
        this.reset();
    }

    public JsonPathExpression getPath() {
        return this.m_Path;
    }

    public String pathTipText() {
        return "The path (or key if not starting with '$') of the value(s) to retrieve.";
    }

    public void setType(SourceType value) {
        this.m_Type = value;
        this.reset();
    }

    public SourceType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "Determines how to obtain the value to store in the map.";
    }

    public void setValue(String value) {
        this.m_Value = value;
        this.reset();
    }

    public String getValue() {
        return this.m_Value;
    }

    public String valueTipText() {
        return "The value to set.";
    }

    public void setSource(CallableActorReference value) {
        this.m_Source = value;
        this.reset();
    }

    public CallableActorReference getSource() {
        return this.m_Source;
    }

    public String sourceTipText() {
        return "The callable source to obtain the value from.";
    }

    public void setStorage(StorageName value) {
        this.m_Storage = value;
        this.reset();
    }

    public StorageName getStorage() {
        return this.m_Storage;
    }

    public String storageTipText() {
        return "The storage item to obtain the value from.";
    }

    public void setConversion(Conversion value) {
        this.m_Conversion = value;
        this.m_Conversion.setOwner((Object)this);
        this.reset();
    }

    public Conversion getConversion() {
        return this.m_Conversion;
    }

    public String conversionTipText() {
        return "The type of conversion to perform.";
    }

    public Class[] accepts() {
        return new Class[]{JSONObject.class, String.class};
    }

    public Class[] generates() {
        return new Class[]{JSONObject.class};
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"path", (Object)(this.m_Path.isEmpty() ? "-empty-" : this.m_Path), (String)"path: ");
        result = result + " = ";
        switch (this.m_Type) {
            case VALUE: {
                result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"value", (Object)(this.m_Value.isEmpty() ? "-none-" : this.m_Value));
                break;
            }
            case SOURCE: {
                result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"source", (Object)(this.m_Source + " (source)"));
                break;
            }
            case STORAGE: {
                result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"storage", (Object)(this.m_Storage + " (storage)"));
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled type: " + (Object)((Object)this.m_Type));
            }
        }
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"conversion", (Object)this.m_Conversion, (String)", conversion: ");
        return result;
    }

    public boolean isUsingStorage() {
        return this.m_Type == SourceType.STORAGE;
    }

    protected Actor findCallableActor() {
        return this.m_Helper.findCallableActorRecursive((Actor)this, this.getSource());
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_SourceActor = null;
            if (this.m_Type == SourceType.SOURCE) {
                Actor source = this.findCallableActor();
                if (source != null) {
                    if (source instanceof OutputProducer) {
                        this.m_SourceActor = source;
                    } else {
                        result = "Callable actor '" + this.m_Source + "' does not produce any output!";
                    }
                } else {
                    result = "Failed to locate source actor: " + this.m_Source;
                }
            }
        }
        return result;
    }

    protected String doExecute() {
        Object obj;
        String result = null;
        JSONObject json = null;
        Object value = null;
        if (this.m_InputToken.isNull()) {
            result = "Null token instead of JSON received at input!";
            return result;
        }
        if (this.m_InputToken.hasPayload(String.class)) {
            obj = JsonHelper.parse((String)this.m_InputToken.getPayload(String.class), (LoggingSupporter)this);
            if (obj == null) {
                result = "Failed to parse JSON string: " + (String)this.m_InputToken.getPayload(String.class);
            }
        } else {
            obj = this.m_InputToken.getPayload();
        }
        if (!(obj instanceof JSONObject)) {
            result = "Input is not a " + Utils.classToString(JSONObject.class) + " instance!";
        } else {
            json = (JSONObject)obj;
        }
        if (result == null) {
            if (!this.m_PathCompiled) {
                this.m_ActualPath = this.m_Path.toJsonPath();
                this.m_PathCompiled = true;
            }
            switch (this.m_Type) {
                case VALUE: {
                    value = this.m_Value;
                    break;
                }
                case SOURCE: {
                    Token token = null;
                    result = this.m_SourceActor.execute();
                    if (result != null) {
                        result = "Callable actor '" + this.m_Source + "' execution failed:\n" + result;
                    } else if (((OutputProducer)this.m_SourceActor).hasPendingOutput()) {
                        token = ((OutputProducer)this.m_SourceActor).output();
                    } else {
                        result = "Callable actor '" + this.m_Source + "' did not generate any output!";
                    }
                    if (token == null) break;
                    value = token.getPayload();
                    break;
                }
                case STORAGE: {
                    if (this.getStorageHandler().getStorage().has(this.m_Storage)) {
                        value = this.getStorageHandler().getStorage().get(this.m_Storage);
                        break;
                    }
                    result = "Storage item not found: " + this.m_Storage;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled type: " + (Object)((Object)this.m_Type));
                }
            }
            if (value != null) {
                this.m_Conversion.setInput(value);
                result = this.m_Conversion.convert();
                if (result == null) {
                    value = this.m_Conversion.getOutput();
                    if (this.m_Path.isSimpleKey() || this.m_ActualPath == null) {
                        json.put((Object)this.m_Path.getValue(), value);
                    } else {
                        this.m_ActualPath.set((Object)json, value, Configuration.defaultConfiguration());
                    }
                }
                this.m_Conversion.cleanUp();
            }
            this.m_OutputToken = new Token((Object)json);
        }
        return result;
    }

    public static enum SourceType {
        VALUE,
        SOURCE,
        STORAGE;

    }
}

