/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.PlaceholderFile;
import adams.core.logging.LoggingHelper;
import adams.core.option.AbstractArgumentOption;
import adams.env.Environment;
import adams.flow.AbstractFlowTest;
import adams.flow.control.Flow;
import adams.flow.core.Actor;
import adams.flow.execution.FlowExecutionListener;
import adams.flow.execution.NullListener;
import adams.flow.sink.DumpFile;
import adams.flow.source.FileSupplier;
import adams.flow.transformer.JsonFileReader;
import adams.test.TmpFile;
import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;

public class JsonFileReaderTest
extends AbstractFlowTest {
    public JsonFileReaderTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.m_TestHelper.copyResourceToTmp("glossary.json");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
    }

    protected void tearDown() throws Exception {
        this.m_TestHelper.deleteFileFromTmp("glossary.json");
        this.m_TestHelper.deleteFileFromTmp("dumpfile.txt");
        super.tearDown();
    }

    public void testRegression() {
        this.performRegressionTest((File[])new TmpFile[]{new TmpFile("dumpfile.txt")});
    }

    public static Test suite() {
        return new TestSuite(JsonFileReaderTest.class);
    }

    public Actor getActor() {
        Flow flow = new Flow();
        try {
            AbstractArgumentOption argOption = (AbstractArgumentOption)flow.getOptionManager().findByProperty("actors");
            Actor[] abstractactor1 = new Actor[3];
            FileSupplier singlefilesupplier2 = new FileSupplier();
            argOption = (AbstractArgumentOption)singlefilesupplier2.getOptionManager().findByProperty("files");
            singlefilesupplier2.setFiles(new PlaceholderFile[]{(PlaceholderFile)argOption.valueOf("${TMP}/glossary.json")});
            abstractactor1[0] = singlefilesupplier2;
            JsonFileReader jsonfilereader4 = new JsonFileReader();
            abstractactor1[1] = jsonfilereader4;
            DumpFile dumpfile5 = new DumpFile();
            argOption = (AbstractArgumentOption)dumpfile5.getOptionManager().findByProperty("outputFile");
            dumpfile5.setOutputFile((PlaceholderFile)argOption.valueOf("${TMP}/dumpfile.txt"));
            abstractactor1[2] = dumpfile5;
            flow.setActors(abstractactor1);
            argOption = (AbstractArgumentOption)flow.getOptionManager().findByProperty("flowExecutionListener");
            NullListener nulllistener8 = new NullListener();
            flow.setFlowExecutionListener((FlowExecutionListener)nulllistener8);
        }
        catch (Exception e) {
            JsonFileReaderTest.fail((String)("Failed to set up actor:\n" + LoggingHelper.throwableToString((Throwable)e)));
        }
        return flow;
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        JsonFileReaderTest.runTest((Test)JsonFileReaderTest.suite());
    }
}

