/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.data.io.input.AbstractReportReader;
import adams.data.report.Report;
import adams.data.report.ReportJsonUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public abstract class AbstractSimpleJsonReportReader<T extends Report>
extends AbstractReportReader<T> {
    private static final long serialVersionUID = 8997935127278404969L;
    public static final String FILE_EXTENSION = "json";

    public String globalInfo() {
        return "Reads a report file in JSON file format.";
    }

    public String getFormatDescription() {
        return "Simple report JSON file format";
    }

    public String[] getFormatExtensions() {
        return new String[]{FILE_EXTENSION};
    }

    protected int determineParentID(Report report) {
        return report.getDatabaseID();
    }

    protected List<T> readData() {
        ArrayList<Report> result = new ArrayList<Report>();
        result.add(this.newInstance());
        ((Report)result.get(0)).setLoggingLevel(this.getLoggingLevel());
        List lines = FileUtils.loadFromFile((File)this.getInput());
        if (lines != null) {
            try {
                Report report = ReportJsonUtils.fromJson(new BufferedReader(new StringReader(Utils.flatten((List)lines, (String)"\n"))));
                ((Report)result.get(0)).mergeWith(report);
            }
            catch (Exception e) {
                this.getLogger().log(Level.SEVERE, "Failed to parse JSON!", (Throwable)e);
            }
        }
        return result;
    }
}

