/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.option.JsonConsumer;
import adams.data.io.input.AbstractFlowReader;
import adams.data.io.output.FlowWriter;
import adams.data.io.output.JsonFlowWriter;
import adams.flow.core.Actor;
import java.io.File;
import java.util.Collection;

public class JsonFlowReader
extends AbstractFlowReader {
    private static final long serialVersionUID = 4618819455357416453L;

    public String globalInfo() {
        return "Reads flows in JSON format.";
    }

    public String getFormatDescription() {
        return "JSON file";
    }

    public String[] getFormatExtensions() {
        return new String[]{"json", "json.gz"};
    }

    protected AbstractFlowReader.InputType getInputType() {
        return AbstractFlowReader.InputType.FILE;
    }

    protected Actor doReadActor(File file) {
        JsonConsumer consumer = new JsonConsumer();
        Actor result = (Actor)consumer.read(file.getAbsolutePath());
        this.m_Errors.addAll((Collection)consumer.getErrors());
        this.m_Warnings.addAll((Collection)consumer.getWarnings());
        return result;
    }

    public FlowWriter getCorrespondingWriter() {
        return new JsonFlowWriter();
    }
}

