/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.MessageCollection;
import adams.data.indexedsplits.IndexedSplit;
import adams.data.indexedsplits.IndexedSplits;
import adams.data.indexedsplits.IndexedSplitsRun;
import adams.data.indexedsplits.IndexedSplitsRuns;
import adams.data.indexedsplits.SplitIndices;
import adams.data.io.input.AbstractIndexedSplitsRunsReader;
import com.google.gson.Gson;
import java.io.Reader;
import java.util.List;
import java.util.Map;

public class JsonIndexedSplitsRunsReader
extends AbstractIndexedSplitsRunsReader {
    private static final long serialVersionUID = -1229985773501645279L;

    public String globalInfo() {
        return "Reads runs of indexed splits from JSON.";
    }

    public String getFormatDescription() {
        return "JSON indexed splits";
    }

    public String[] getFormatExtensions() {
        return new String[]{"json"};
    }

    public String getDefaultFormatExtension() {
        return "json";
    }

    protected IndexedSplitsRuns doRead(Reader reader, MessageCollection errors) {
        try {
            Gson gson = new Gson();
            Map map = (Map)gson.fromJson(reader, Map.class);
            if (!map.containsKey("runs")) {
                errors.add("Failed to locate top-level 'runs' property!");
                return null;
            }
            IndexedSplitsRuns result = new IndexedSplitsRuns();
            if (map.containsKey("meta-data")) {
                Map meta = (Map)map.get("meta-data");
                for (Object key : meta.keySet()) {
                    result.getMetaData().put((Object)("" + key), (Object)("" + meta.get(key)));
                }
            }
            List jruns = (List)map.get("runs");
            for (int ir = 0; ir < jruns.size(); ++ir) {
                Map jrun = (Map)jruns.get(ir);
                if (!jrun.containsKey("splits")) {
                    errors.add("Failed to locate 'splits' property!");
                    return null;
                }
                List jsplits = (List)jrun.get("splits");
                IndexedSplits splits = new IndexedSplits();
                IndexedSplitsRun run = new IndexedSplitsRun(ir, splits);
                result.add((Object)run);
                for (int is = 0; is < jsplits.size(); ++is) {
                    Map jsplit = (Map)jsplits.get(is);
                    IndexedSplit split = new IndexedSplit(is);
                    for (Object key : jsplit.keySet()) {
                        List jindices = (List)jsplit.get(key);
                        int[] intIndices = new int[jindices.size()];
                        for (int ii = 0; ii < jindices.size(); ++ii) {
                            intIndices[ii] = ((Number)jindices.get(ii)).intValue();
                        }
                        SplitIndices splindices = new SplitIndices("" + key, intIndices);
                        split.add(splindices);
                    }
                    splits.add((Object)split);
                }
            }
            return result;
        }
        catch (Exception e) {
            errors.add("Failed to read from JSON!", (Throwable)e);
            return null;
        }
    }
}

