/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.io.FileUtils;
import adams.core.io.PrettyPrintingSupporter;
import adams.data.io.output.AbstractReportWriter;
import adams.data.report.Report;
import adams.data.report.ReportJsonUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public abstract class AbstractSimpleJsonReportWriter<T extends Report>
extends AbstractReportWriter<T>
implements PrettyPrintingSupporter {
    private static final long serialVersionUID = 1068874780353203514L;
    protected boolean m_PrettyPrinting;

    public String globalInfo() {
        return "Writes reports in JSON file format.";
    }

    public String getFormatDescription() {
        return "JSON file format";
    }

    public String[] getFormatExtensions() {
        return new String[]{"json"};
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("pretty-printing", "prettyPrinting", (Object)false);
    }

    public void setPrettyPrinting(boolean value) {
        this.m_PrettyPrinting = value;
        this.reset();
    }

    public boolean getPrettyPrinting() {
        return this.m_PrettyPrinting;
    }

    public String prettyPrintingTipText() {
        return "If enabled, the output is printed in a 'pretty' format.";
    }

    protected boolean writeData(T data) {
        JsonObject jobj = ReportJsonUtils.toJson(data);
        GsonBuilder builder = new GsonBuilder();
        if (this.m_PrettyPrinting) {
            builder.setPrettyPrinting();
        }
        Gson gson = builder.create();
        boolean result = FileUtils.writeToFile((String)this.m_Output.getAbsolutePath(), (Object)gson.toJson((JsonElement)jobj), (boolean)false);
        if (!result) {
            this.getLogger().severe("Error writing report #" + data.getDatabaseID() + " to " + this.m_Output);
        }
        return result;
    }
}

