/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.MessageCollection;
import adams.core.io.FileUtils;
import adams.core.io.PrettyPrintingSupporter;
import adams.data.indexedsplits.IndexedSplit;
import adams.data.indexedsplits.IndexedSplitsRun;
import adams.data.indexedsplits.IndexedSplitsRuns;
import adams.data.indexedsplits.SplitIndices;
import adams.data.io.input.JsonIndexedSplitsRunsReader;
import adams.data.io.output.AbstractIndexedSplitsRunsWriter;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import java.io.Closeable;
import java.io.Writer;

public class JsonIndexedSplitsRunsWriter
extends AbstractIndexedSplitsRunsWriter
implements PrettyPrintingSupporter {
    private static final long serialVersionUID = 5188430181037862982L;
    protected boolean m_PrettyPrinting;

    public String globalInfo() {
        return "Writes runs of indexed splits as JSON.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("pretty-printing", "prettyPrinting", (Object)false);
    }

    public void setPrettyPrinting(boolean value) {
        this.m_PrettyPrinting = value;
        this.reset();
    }

    public boolean getPrettyPrinting() {
        return this.m_PrettyPrinting;
    }

    public String prettyPrintingTipText() {
        return "If enabled, the output is printed in a 'pretty' format.";
    }

    public String getFormatDescription() {
        return new JsonIndexedSplitsRunsReader().getFormatDescription();
    }

    public String[] getFormatExtensions() {
        return new JsonIndexedSplitsRunsReader().getFormatExtensions();
    }

    public String getDefaultFormatExtension() {
        return new JsonIndexedSplitsRunsReader().getDefaultFormatExtension();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doWrite(Writer writer, IndexedSplitsRuns runs, MessageCollection errors) {
        boolean bl;
        JsonObject json = new JsonObject();
        JsonArray rs = new JsonArray();
        json.add("runs", (JsonElement)rs);
        for (IndexedSplitsRun run : runs) {
            JsonObject r = new JsonObject();
            rs.add((JsonElement)r);
            JsonArray spls = new JsonArray();
            r.add("splits", (JsonElement)spls);
            for (IndexedSplit split : run.getSplits()) {
                JsonObject spl = new JsonObject();
                spls.add((JsonElement)spl);
                for (String splitName : split.getIndices().keySet()) {
                    SplitIndices ind = (SplitIndices)split.getIndices().get(splitName);
                    JsonArray jind = new JsonArray(ind.size());
                    for (int i : ind.getIndices()) {
                        jind.add((Number)i);
                    }
                    spl.add(splitName, (JsonElement)jind);
                }
            }
        }
        JsonObject meta = new JsonObject();
        for (String key : runs.getMetaData().keySet()) {
            Object value = runs.getMetaData().get((Object)key);
            if (value instanceof Number) {
                meta.addProperty(key, (Number)value);
                continue;
            }
            if (value instanceof Boolean) {
                meta.addProperty(key, (Boolean)value);
                continue;
            }
            if (value instanceof Character) {
                meta.addProperty(key, (Character)value);
                continue;
            }
            meta.addProperty(key, "" + value);
        }
        json.add("meta-data", (JsonElement)meta);
        JsonWriter jwriter = null;
        try {
            jwriter = new JsonWriter(writer);
            if (this.m_PrettyPrinting) {
                jwriter.setIndent("  ");
            }
            jwriter.setLenient(true);
            Streams.write((JsonElement)json, (JsonWriter)jwriter);
            bl = true;
        }
        catch (Exception e) {
            boolean bl2;
            try {
                errors.add("Failed to write JSON!", (Throwable)e);
                bl2 = false;
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(jwriter);
                throw throwable;
            }
            FileUtils.closeQuietly((Closeable)jwriter);
            return bl2;
        }
        FileUtils.closeQuietly((Closeable)jwriter);
        return bl;
    }
}

