/*
 * Decompiled with CFR 0.152.
 */
package adams.data.json;

import adams.core.io.FileUtils;
import adams.core.logging.LoggingSupporter;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.logging.Level;
import net.minidev.json.JSONAware;
import net.minidev.json.parser.JSONParser;

public class JsonHelper {
    protected static Object parse(Reader reader) throws Exception {
        JSONParser parser = new JSONParser(1984);
        return parser.parse(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object parse(String json, LoggingSupporter logging) {
        Object object;
        StringReader sreader = null;
        BufferedReader breader = null;
        try {
            sreader = new StringReader(json);
            breader = new BufferedReader(sreader);
            object = JsonHelper.parse(breader);
        }
        catch (Exception e) {
            Object var5_6;
            try {
                if (logging != null) {
                    logging.getLogger().log(Level.SEVERE, "Failed to read JSON string: " + json, (Throwable)e);
                } else {
                    System.err.println("Failed to read JSON string: " + json);
                    e.printStackTrace();
                }
                var5_6 = null;
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(breader);
                FileUtils.closeQuietly((Reader)sreader);
                throw throwable;
            }
            FileUtils.closeQuietly((Reader)breader);
            FileUtils.closeQuietly((Reader)sreader);
            return var5_6;
        }
        FileUtils.closeQuietly((Reader)breader);
        FileUtils.closeQuietly((Reader)sreader);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object parse(File file, LoggingSupporter logging) {
        Object object;
        FileReader freader = null;
        BufferedReader breader = null;
        try {
            freader = new FileReader(file.getAbsolutePath());
            breader = new BufferedReader(freader);
            object = JsonHelper.parse(breader);
        }
        catch (Exception e) {
            Object var5_6;
            try {
                if (logging != null) {
                    logging.getLogger().log(Level.SEVERE, "Failed to read JSON file: " + file, (Throwable)e);
                } else {
                    System.err.println("Failed to read JSON file: " + file);
                    e.printStackTrace();
                }
                var5_6 = null;
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(breader);
                FileUtils.closeQuietly((Reader)freader);
                throw throwable;
            }
            FileUtils.closeQuietly((Reader)breader);
            FileUtils.closeQuietly((Reader)freader);
            return var5_6;
        }
        FileUtils.closeQuietly((Reader)breader);
        FileUtils.closeQuietly((Reader)freader);
        return object;
    }

    public static String prettyPrint(JSONAware json) {
        return JsonHelper.prettyPrint(json.toJSONString());
    }

    public static String prettyPrint(JsonElement json) {
        return new GsonBuilder().setPrettyPrinting().create().toJson(json);
    }

    public static String prettyPrint(String json) {
        JsonParser jp = new JsonParser();
        JsonElement je = jp.parse(json);
        return JsonHelper.prettyPrint(je);
    }
}

