/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.JsonSupporter;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.AbstractTextDisplayPanel;
import adams.flow.sink.DisplayPanel;
import adams.flow.sink.DisplayPanelProvider;
import adams.flow.sink.TextSupplier;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.ExtensionFileFilter;
import adams.gui.core.json.JsonTree;
import adams.gui.core.json.JsonTreeWithPreview;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONValue;

public class JsonDisplay
extends AbstractGraphicalDisplay
implements DisplayPanelProvider,
TextSupplier {
    private static final long serialVersionUID = 680299970232233254L;
    protected JsonSupporter m_Tree;
    protected boolean m_Preview;
    protected boolean m_Expand;
    protected boolean m_SortKeys;

    public String globalInfo() {
        return "Displays a JSON object as tree structure.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("preview", "preview", (Object)false);
        this.m_OptionManager.add("expand", "expand", (Object)false);
        this.m_OptionManager.add("sort-keys", "sortKeys", (Object)false);
    }

    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"preview", (boolean)this.m_Preview, (String)"preview", (String)", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"expand", (boolean)this.m_Expand, (String)"expand", (String)", ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"sortKeys", (boolean)this.m_SortKeys, (String)"sort keys", (String)", ");
        return result;
    }

    public void setPreview(boolean value) {
        this.m_Preview = value;
        this.reset();
    }

    public boolean getPreview() {
        return this.m_Preview;
    }

    public String previewTipText() {
        return "If enabled, a text area is shown that displays the JSON object associated with the currently selected node in the tree.";
    }

    public void setExpand(boolean value) {
        this.m_Expand = value;
        this.reset();
    }

    public boolean getExpand() {
        return this.m_Expand;
    }

    public String expandTipText() {
        return "If enabled, the tree gets fully expanded.";
    }

    public void setSortKeys(boolean value) {
        this.m_SortKeys = value;
        this.reset();
    }

    public boolean getSortKeys() {
        return this.m_SortKeys;
    }

    public String sortKeysTipText() {
        return "If enabled, the keys of JSONObject objects will get sorted for display.";
    }

    public Class[] accepts() {
        return new Class[]{JSONAware.class};
    }

    protected void display(Token token) {
        this.m_Tree.setJSON((JSONAware)token.getPayload());
        if (this.m_Expand) {
            if (this.m_Tree instanceof JsonTreeWithPreview) {
                ((JsonTreeWithPreview)this.m_Tree).getTree().expandAll();
            } else if (this.m_Tree instanceof JsonTree) {
                ((JsonTree)this.m_Tree).expandAll();
            }
        }
    }

    public void clearPanel() {
        if (this.m_Tree != null) {
            this.m_Tree.setJSON(null);
        }
    }

    protected BasePanel newPanel() {
        BasePanel result;
        if (this.m_Preview) {
            this.m_Tree = new JsonTreeWithPreview();
            ((JsonTreeWithPreview)this.m_Tree).setSortKeys(this.m_SortKeys);
            result = (BasePanel)this.m_Tree;
        } else {
            this.m_Tree = new JsonTree();
            ((JsonTree)this.m_Tree).setSortKeys(this.m_SortKeys);
            result = new BasePanel((LayoutManager)new BorderLayout());
            result.add((Component)new BaseScrollPane((Component)((JComponent)((Object)this.m_Tree))), (Object)"Center");
        }
        return result;
    }

    public String getCustomSupplyTextMenuItemCaption() {
        return "Save JSON as...";
    }

    public ExtensionFileFilter getCustomTextFileFilter() {
        return new ExtensionFileFilter("JSON", "json");
    }

    public String supplyText() {
        if (this.m_Tree != null) {
            return JSONValue.toJSONString((Object)this.m_Tree.getJSON());
        }
        return null;
    }

    public DisplayPanel createDisplayPanel(Token token) {
        AbstractTextDisplayPanel result = new AbstractTextDisplayPanel(((Object)((Object)this)).getClass().getSimpleName()){
            private static final long serialVersionUID = 4356468458332186521L;
            protected JsonSupporter m_Tree;

            protected void initGUI() {
                super.initGUI();
                if (JsonDisplay.this.m_Preview) {
                    this.m_Tree = new JsonTreeWithPreview();
                    ((JsonTreeWithPreview)this.m_Tree).setSortKeys(JsonDisplay.this.m_SortKeys);
                    this.add((JComponent)((Object)this.m_Tree), "Center");
                } else {
                    this.m_Tree = new JsonTree();
                    ((JsonTree)this.m_Tree).setSortKeys(JsonDisplay.this.m_SortKeys);
                    this.add((Component)new BaseScrollPane((Component)((JComponent)((Object)this.m_Tree))), "Center");
                }
            }

            public void display(Token token) {
                this.m_Tree.setJSON((JSONAware)token.getPayload());
                if (JsonDisplay.this.m_Expand) {
                    if (this.m_Tree instanceof JsonTreeWithPreview) {
                        ((JsonTreeWithPreview)this.m_Tree).getTree().expandAll();
                    } else if (this.m_Tree instanceof JsonTree) {
                        ((JsonTree)this.m_Tree).expandAll();
                    }
                }
            }

            public void clearPanel() {
                this.m_Tree.setJSON(null);
            }

            public void cleanUp() {
                this.m_Tree.setJSON(null);
            }

            public ExtensionFileFilter getCustomTextFileFilter() {
                return new ExtensionFileFilter("JSON", "json");
            }

            public String supplyText() {
                if (this.m_Tree != null) {
                    return JSONValue.toJSONString((Object)this.m_Tree.getJSON());
                }
                return null;
            }
        };
        if (token != null) {
            result.display(token);
        }
        return result;
    }

    public boolean displayPanelRequiresScrollPane() {
        return false;
    }
}

