/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.JsonDataType;
import adams.core.QuickInfoHelper;
import adams.core.base.JsonPathExpression;
import adams.core.logging.LoggingSupporter;
import adams.core.option.OptionHandler;
import adams.data.json.JsonHelper;
import adams.flow.transformer.AbstractArrayProvider;
import com.jayway.jsonpath.JsonPath;
import java.util.ArrayList;
import java.util.List;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONObject;

public class GetJsonValue
extends AbstractArrayProvider {
    private static final long serialVersionUID = -8757919765508522198L;
    protected JsonPathExpression m_Path;
    protected JsonDataType m_DataType;
    protected boolean m_ForwardNull;
    protected transient JsonPath m_ActualPath;
    protected transient boolean m_PathCompiled;

    public String globalInfo() {
        return "Obtains the value associated with the specified key from the JSON object passing through.\nNull values are only forwarded if requested.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("path", "path", (Object)new JsonPathExpression());
        this.m_OptionManager.add("data-type", "dataType", (Object)JsonDataType.OBJECT);
        this.m_OptionManager.add("forward-null", "forwardNull", (Object)false);
    }

    protected void reset() {
        super.reset();
        this.m_ActualPath = null;
        this.m_PathCompiled = false;
    }

    protected Class getItemClass() {
        switch (this.m_DataType) {
            case BOOLEAN: {
                return Boolean.class;
            }
            case NUMBER: {
                return Double.class;
            }
            case STRING: {
                return String.class;
            }
            case OBJECT: {
                return JSONObject.class;
            }
            case ARRAY: {
                return JSONArray.class;
            }
        }
        throw new IllegalStateException("Unhandled JSON data type: " + (Object)((Object)this.m_DataType));
    }

    public String outputArrayTipText() {
        return "Whether to output the JSON values as array or one-by-one.";
    }

    public void setPath(JsonPathExpression value) {
        this.m_Path = value;
        this.reset();
    }

    public JsonPathExpression getPath() {
        return this.m_Path;
    }

    public String pathTipText() {
        return "The path (or key if not starting with '$') of the value(s) to retrieve.";
    }

    public void setDataType(JsonDataType value) {
        this.m_DataType = value;
        this.reset();
    }

    public JsonDataType getDataType() {
        return this.m_DataType;
    }

    public String dataTypeTipText() {
        return "The type of the data that is output.";
    }

    public void setForwardNull(boolean value) {
        this.m_ForwardNull = value;
        this.reset();
    }

    public boolean getForwardNull() {
        return this.m_ForwardNull;
    }

    public String forwardNullTipText() {
        return "If enabled, null values are forward as well.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"path", (Object)((Object)this.m_Path), (String)"path: ");
        result = result != null ? result + ", " : "";
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"dataType", (Object)((Object)this.m_DataType), (String)"data-type: ");
        ArrayList options = new ArrayList();
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"outputArray", (boolean)this.m_OutputArray, (String)"output array"));
        QuickInfoHelper.add(options, (String)QuickInfoHelper.toString((OptionHandler)this, (String)"forwardNull", (boolean)this.m_ForwardNull, (String)"forward null"));
        result = result + QuickInfoHelper.flatten(options);
        return result;
    }

    public Class[] accepts() {
        return new Class[]{JSONAware.class, JSONObject.class, String.class};
    }

    protected String doExecute() {
        Object obj;
        String result = null;
        JSONObject json = null;
        if (this.m_InputToken.hasPayload(String.class)) {
            obj = JsonHelper.parse((String)this.m_InputToken.getPayload(String.class), (LoggingSupporter)this);
            if (obj == null) {
                result = "Failed to parse JSON string: " + (String)this.m_InputToken.getPayload(String.class);
            }
        } else {
            obj = this.m_InputToken.getPayload();
        }
        if (!(obj instanceof JSONObject)) {
            result = "Input is not of type " + JSONObject.class.getName() + "!";
        } else {
            json = (JSONObject)obj;
        }
        if (result == null) {
            if (!this.m_PathCompiled) {
                this.m_ActualPath = this.m_Path.toJsonPath();
                this.m_PathCompiled = true;
            }
            if (this.m_Path.isSimpleKey() || this.m_ActualPath == null) {
                if (json.containsKey((Object)this.m_Path.getValue())) {
                    Object val = json.get((Object)this.m_Path.getValue());
                    if (this.isLoggingEnabled()) {
                        this.getLogger().info("Found value for '" + this.m_Path.getValue() + "': " + val);
                    }
                    if (val instanceof Number) {
                        val = ((Number)val).doubleValue();
                    }
                    if (val != null || this.m_ForwardNull) {
                        this.m_Queue.add(val);
                    }
                } else if (this.isLoggingEnabled()) {
                    this.getLogger().info("No value found for '" + this.m_Path.getValue() + "'!");
                }
            } else {
                Object val = this.m_ActualPath.read((Object)json);
                if (val instanceof JSONArray) {
                    this.m_Queue.add(val);
                } else if (val instanceof List) {
                    this.m_Queue.addAll((List)val);
                } else {
                    this.m_Queue.add(val);
                }
            }
        }
        return result;
    }
}

