/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractConversion;
import adams.data.json.JsonHelper;
import java.util.Map;
import net.minidev.json.JSONObject;

public class JsonObjectToMap
extends AbstractConversion {
    private static final long serialVersionUID = -468714756281370533L;
    protected boolean m_ArraysAsLists;

    public String globalInfo() {
        return "Turns a JSON object into a map.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("arrays-as-lists", "arraysAsLists", (Object)false);
    }

    public void setArraysAsLists(boolean value) {
        this.m_ArraysAsLists = value;
        this.reset();
    }

    public boolean getArraysAsLists() {
        return this.m_ArraysAsLists;
    }

    public String arraysAsListsTipText() {
        return "If enabled, JSON arrays get converted to Java lists rather than Java arrays.";
    }

    public Class accepts() {
        return JSONObject.class;
    }

    public Class generates() {
        return Map.class;
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"arraysAsLists", (Object)(this.m_ArraysAsLists ? "as-lists" : "as-arrays"), (String)"output: ");
    }

    protected Object doConvert() throws Exception {
        return JsonHelper.toMap((JSONObject)this.m_Input, this.m_ArraysAsLists);
    }
}

