/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.logging.LoggingSupporter;
import adams.data.conversion.AbstractConversionFromString;
import adams.data.json.JsonHelper;
import adams.data.json.JsonObjectType;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONObject;

public class StringToJson
extends AbstractConversionFromString {
    private static final long serialVersionUID = 1484255065339335859L;
    protected JsonObjectType m_Type;

    public String globalInfo() {
        return "Turns a string into a JSON object or array.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)JsonObjectType.ANY);
    }

    public void setType(JsonObjectType value) {
        this.m_Type = value;
        this.reset();
    }

    public JsonObjectType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of object to forward.";
    }

    public Class generates() {
        switch (this.m_Type) {
            case ANY: {
                return JSONAware.class;
            }
            case ARRAY: {
                return JSONArray.class;
            }
            case OBJECT: {
                return JSONObject.class;
            }
        }
        throw new IllegalStateException("Unhandled type: " + this.m_Type);
    }

    protected Object doConvert() throws Exception {
        try {
            Object result = JsonHelper.parse((String)this.m_Input, (LoggingSupporter)this);
            switch (this.m_Type) {
                case ANY: {
                    return result;
                }
                case ARRAY: {
                    return (JSONArray)result;
                }
                case OBJECT: {
                    return (JSONObject)result;
                }
            }
            throw new IllegalStateException("Unhandled type: " + this.m_Type);
        }
        catch (Exception e) {
            throw new Exception("Failed to parse: " + this.m_Input, e);
        }
    }
}

