/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.logging.LoggingSupporter;
import adams.data.io.input.AbstractReportReader;
import adams.data.json.JsonHelper;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minidev.json.JSONObject;

public class ImageClassificationJsonReportReader
extends AbstractReportReader<Report> {
    private static final long serialVersionUID = 961116146272004314L;
    protected Field m_FieldLabel;
    protected Field m_FieldScore;

    public String globalInfo() {
        return "Retrieves the label with the highest score from the JSON file and stores them in a report.\nJSON file format: { LABEL1: SCORE1; LABEL2: SCORE2;  }";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("field-label", "fieldLabel", (Object)new Field("Classification", DataType.STRING));
        this.m_OptionManager.add("field-score", "fieldScore", (Object)new Field("Score", DataType.NUMERIC));
    }

    public void setFieldLabel(Field value) {
        this.m_FieldLabel = value;
        this.reset();
    }

    public Field getFieldLabel() {
        return this.m_FieldLabel;
    }

    public String fieldLabelTipText() {
        return "The field to store the label under.";
    }

    public void setFieldScore(Field value) {
        this.m_FieldScore = value;
        this.reset();
    }

    public Field getFieldScore() {
        return this.m_FieldScore;
    }

    public String fieldScoreTipText() {
        return "The field to store the score under.";
    }

    public String getFormatDescription() {
        return "Image classification predictions";
    }

    public String[] getFormatExtensions() {
        return new String[]{"json"};
    }

    protected int determineParentID(Report report) {
        return -1;
    }

    public Report newInstance() {
        return new Report();
    }

    protected List<Report> readData() {
        ArrayList<Report> result = new ArrayList<Report>();
        Object json = JsonHelper.parse((File)this.m_Input, (LoggingSupporter)this);
        String label = null;
        double score = 0.0;
        if (json instanceof JSONObject) {
            JSONObject obj = (JSONObject)json;
            for (String key : obj.keySet()) {
                try {
                    if (!(obj.getAsNumber(key).doubleValue() > score)) continue;
                    label = key;
                    score = obj.getAsNumber(key).doubleValue();
                }
                catch (Exception exception) {}
            }
        }
        if (label != null) {
            Report report = new Report();
            report.setValue((AbstractField)this.m_FieldLabel, label);
            report.setValue((AbstractField)this.m_FieldScore, (Object)score);
            result.add(report);
        } else {
            this.getLogger().severe("Failed to determine label/score from: " + this.m_Input);
        }
        return result;
    }
}

