/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.data.io.input.JsonParameterMapReader;
import adams.data.io.output.AbstractParameterMapWriter;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Map;

public class JsonParameterMapWriter
extends AbstractParameterMapWriter {
    private static final long serialVersionUID = -8694223705531146951L;

    public String globalInfo() {
        return "Writes parameters in JSON format.";
    }

    public String getFormatDescription() {
        return new JsonParameterMapReader().getFormatDescription();
    }

    public String[] getFormatExtensions() {
        return new JsonParameterMapReader().getFormatExtensions();
    }

    public String getDefaultFormatExtension() {
        return new JsonParameterMapReader().getDefaultFormatExtension();
    }

    protected void doWrite(Map<String, Object> params, PlaceholderFile output) throws Exception {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String msg = FileUtils.writeToFileMsg((String)output.getAbsolutePath(), (Object)gson.toJson(params), (boolean)false, null);
        if (msg != null) {
            throw new Exception(msg);
        }
    }
}

