/*
 * Decompiled with CFR 0.152.
 */
package adams.data.json;

import adams.core.io.FileUtils;
import adams.core.logging.LoggingSupporter;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;

public class JsonHelper {
    public static Object parse(Reader reader) throws Exception {
        JSONParser parser = new JSONParser(1984);
        return parser.parse(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object parse(String json, LoggingSupporter logging) {
        Object object;
        StringReader sreader = null;
        BufferedReader breader = null;
        try {
            sreader = new StringReader(json);
            breader = new BufferedReader(sreader);
            object = JsonHelper.parse(breader);
        }
        catch (Exception e) {
            Object var5_6;
            try {
                if (logging != null) {
                    logging.getLogger().log(Level.SEVERE, "Failed to read JSON string: " + json, (Throwable)e);
                } else {
                    System.err.println("Failed to read JSON string: " + json);
                    e.printStackTrace();
                }
                var5_6 = null;
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(breader);
                FileUtils.closeQuietly((Reader)sreader);
                throw throwable;
            }
            FileUtils.closeQuietly((Reader)breader);
            FileUtils.closeQuietly((Reader)sreader);
            return var5_6;
        }
        FileUtils.closeQuietly((Reader)breader);
        FileUtils.closeQuietly((Reader)sreader);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object parse(File file, LoggingSupporter logging) {
        Object object;
        FileReader freader = null;
        BufferedReader breader = null;
        try {
            freader = new FileReader(file.getAbsolutePath());
            breader = new BufferedReader(freader);
            object = JsonHelper.parse(breader);
        }
        catch (Exception e) {
            Object var5_6;
            try {
                if (logging != null) {
                    logging.getLogger().log(Level.SEVERE, "Failed to read JSON file: " + file, (Throwable)e);
                } else {
                    System.err.println("Failed to read JSON file: " + file);
                    e.printStackTrace();
                }
                var5_6 = null;
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(breader);
                FileUtils.closeQuietly((Reader)freader);
                throw throwable;
            }
            FileUtils.closeQuietly((Reader)breader);
            FileUtils.closeQuietly((Reader)freader);
            return var5_6;
        }
        FileUtils.closeQuietly((Reader)breader);
        FileUtils.closeQuietly((Reader)freader);
        return object;
    }

    public static String prettyPrint(JSONAware json) {
        return JsonHelper.prettyPrint(json.toJSONString());
    }

    public static String prettyPrint(JsonElement json) {
        return new GsonBuilder().setPrettyPrinting().create().toJson(json);
    }

    public static String prettyPrint(String json) {
        StringReader sreader = new StringReader(json);
        JsonElement je = JsonParser.parseReader((Reader)sreader);
        return JsonHelper.prettyPrint(je);
    }

    public static Object toJSON(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            JSONObject json = new JSONObject();
            for (Object key : map.keySet()) {
                json.put((Object)key.toString(), JsonHelper.toJSON(map.get(key)));
            }
            return json;
        }
        if (value instanceof List) {
            List list = (List)value;
            JSONArray array = new JSONArray();
            for (int i = 0; i < list.size(); ++i) {
                array.add(JsonHelper.toJSON(list.get(i)));
            }
            return array;
        }
        if (value.getClass().isArray()) {
            JSONArray array = new JSONArray();
            for (int i = 0; i < Array.getLength(value); ++i) {
                array.add(JsonHelper.toJSON(Array.get(value, i)));
            }
            return array;
        }
        return value;
    }

    public static Object[] toArray(JSONArray array) {
        Object[] result = new Object[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            Object obj = array.get(i);
            result[i] = obj instanceof JSONArray ? JsonHelper.toArray((JSONArray)obj) : (obj instanceof JSONObject ? JsonHelper.toMap((JSONObject)obj, false) : obj);
        }
        return result;
    }

    public static List<Object> toList(JSONArray array) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < array.size(); ++i) {
            Object obj = array.get(i);
            if (obj instanceof JSONArray) {
                result.add(JsonHelper.toList((JSONArray)obj));
                continue;
            }
            if (obj instanceof JSONObject) {
                result.add(JsonHelper.toMap((JSONObject)obj, true));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public static Map<String, Object> toMap(JSONObject object, boolean arraysAsList) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String key : object.keySet()) {
            Object obj = object.get((Object)key);
            if (obj instanceof JSONObject) {
                result.put(key, JsonHelper.toMap((JSONObject)obj, arraysAsList));
                continue;
            }
            if (obj instanceof JSONArray) {
                if (arraysAsList) {
                    result.put(key, JsonHelper.toList((JSONArray)obj));
                    continue;
                }
                result.put(key, JsonHelper.toArray((JSONArray)obj));
                continue;
            }
            result.put(key, obj);
        }
        return result;
    }
}

