/*
 * Decompiled with CFR 0.152.
 */
package adams.data.report;

import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class ReportJsonUtils {
    public static String example() {
        return "{\n  \"Sample ID\": \"someid\",\n  \"GLV2\": 1.123,\n  \"valid\": true\n}\n";
    }

    public static Report fromJson(Reader reader) throws Exception {
        return ReportJsonUtils.fromJson(reader, null);
    }

    public static Report fromJson(Reader reader, String prefix) throws Exception {
        JsonElement je = JsonParser.parseReader((Reader)reader);
        return ReportJsonUtils.fromJson(je.getAsJsonObject(), prefix);
    }

    public static Report fromJson(JsonObject jobj) {
        return ReportJsonUtils.fromJson(jobj, null);
    }

    public static Report fromJson(JsonObject jobj, String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        Report result = new Report();
        for (Map.Entry entry : jobj.entrySet()) {
            Field field;
            JsonPrimitive prim = ((JsonElement)entry.getValue()).getAsJsonPrimitive();
            if (prim.isBoolean()) {
                field = new Field(prefix + (String)entry.getKey(), DataType.BOOLEAN);
                result.addField((AbstractField)field);
                result.setBooleanValue(field.getName(), prim.getAsBoolean());
                continue;
            }
            if (prim.isNumber()) {
                field = new Field(prefix + (String)entry.getKey(), DataType.NUMERIC);
                result.addField((AbstractField)field);
                result.setNumericValue(field.getName(), prim.getAsNumber().doubleValue());
                continue;
            }
            field = new Field(prefix + (String)entry.getKey(), DataType.STRING);
            result.addField((AbstractField)field);
            result.setStringValue(field.getName(), prim.getAsString());
        }
        return result;
    }

    public static JsonObject toJson(Report report) {
        return ReportJsonUtils.toJson(report, null);
    }

    public static JsonObject toJson(Report report, Field[] fields) {
        JsonObject result = new JsonObject();
        ArrayList<Field> list = fields == null ? report.getFields() : new ArrayList<Field>(Arrays.asList(fields));
        block5: for (AbstractField abstractField : list) {
            switch (abstractField.getDataType()) {
                case NUMERIC: {
                    result.addProperty(abstractField.getName(), (Number)report.getDoubleValue(abstractField));
                    continue block5;
                }
                case BOOLEAN: {
                    result.addProperty(abstractField.getName(), report.getBooleanValue(abstractField));
                    continue block5;
                }
                case STRING: 
                case UNKNOWN: {
                    result.addProperty(abstractField.getName(), report.getStringValue(abstractField));
                    continue block5;
                }
            }
            throw new IllegalStateException("Unhandled data type: " + abstractField.getDataType());
        }
        return result;
    }
}

