/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.source.AbstractSimpleSource;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;

public class NewJsonStructure
extends AbstractSimpleSource {
    private static final long serialVersionUID = -5652163566235489447L;
    protected JsonDataStructure m_DataStructure;

    public String globalInfo() {
        return "Generates an empty JSON data structure of the specified type.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("data-structure", "dataStructure", (Object)JsonDataStructure.OBJECT);
    }

    public void setDataStructure(JsonDataStructure value) {
        this.m_DataStructure = value;
        this.reset();
    }

    public JsonDataStructure getDataStructure() {
        return this.m_DataStructure;
    }

    public String dataStructureTipText() {
        return "The type of data structure to create.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"dataStructure", (Object)((Object)this.m_DataStructure));
    }

    public Class[] generates() {
        switch (this.m_DataStructure) {
            case OBJECT: {
                return new Class[]{JSONObject.class};
            }
            case ARRAY: {
                return new Class[]{JSONArray.class};
            }
        }
        throw new IllegalStateException("Unhandled JSON data structure: " + this.m_DataStructure);
    }

    protected String doExecute() {
        switch (this.m_DataStructure) {
            case OBJECT: {
                this.m_OutputToken = new Token((Object)new JSONObject());
                break;
            }
            case ARRAY: {
                this.m_OutputToken = new Token((Object)new JSONArray());
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled JSON data structure: " + this.m_DataStructure);
            }
        }
        return null;
    }

    public static enum JsonDataStructure {
        OBJECT,
        ARRAY;

    }
}

