/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.base.JsonPathExpression;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import net.minidev.json.JSONObject;

public class DeleteJsonValue
extends AbstractTransformer {
    private static final long serialVersionUID = -8757919765508522198L;
    protected JsonPathExpression m_Path;
    protected transient JsonPath m_ActualPath;
    protected transient boolean m_PathCompiled;

    public String globalInfo() {
        return "Deletes the value associated with the specified key from the JSON object passing through.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("path", "path", (Object)new JsonPathExpression());
    }

    protected void reset() {
        super.reset();
        this.m_ActualPath = null;
        this.m_PathCompiled = false;
    }

    public void setPath(JsonPathExpression value) {
        this.m_Path = value;
        this.reset();
    }

    public JsonPathExpression getPath() {
        return this.m_Path;
    }

    public String pathTipText() {
        return "The path (or key if not starting with '$') of the value(s) to retrieve.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"path", (Object)((Object)this.m_Path), (String)"path: ");
    }

    public Class[] accepts() {
        return new Class[]{JSONObject.class};
    }

    public Class[] generates() {
        return new Class[]{JSONObject.class};
    }

    protected String doExecute() {
        String result = null;
        JSONObject json = (JSONObject)this.m_InputToken.getPayload(JSONObject.class);
        if (!this.m_PathCompiled) {
            this.m_ActualPath = this.m_Path.toJsonPath();
            this.m_PathCompiled = true;
        }
        if (this.m_Path.isSimpleKey() || this.m_ActualPath == null) {
            if (json.containsKey((Object)this.m_Path.getValue())) {
                json.remove((Object)this.m_Path.getValue());
            } else if (this.isLoggingEnabled()) {
                this.getLogger().info("No value found for '" + this.m_Path.getValue() + "'!");
            }
        } else {
            this.m_ActualPath.delete((Object)json, Configuration.builder().build());
        }
        this.m_OutputToken = new Token((Object)json);
        return result;
    }
}

