/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderFile;
import adams.core.logging.LoggingSupporter;
import adams.core.option.OptionHandler;
import adams.data.json.JsonHelper;
import adams.data.json.JsonObjectType;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONAware;
import net.minidev.json.JSONObject;

public class JsonFileReader
extends AbstractTransformer {
    private static final long serialVersionUID = -184602726110144511L;
    protected JsonObjectType m_Type;

    public String globalInfo() {
        return "Reads a JSON file and forwards the parsed JSON object.\nIf it is know beforehand, whether the JSON file contains an object or an array, the output type can be specified.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)JsonObjectType.ANY);
    }

    public void setType(JsonObjectType value) {
        this.m_Type = value;
        this.reset();
    }

    public JsonObjectType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of the output to enforce.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)((Object)this.m_Type));
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    public Class[] generates() {
        switch (this.m_Type) {
            case ANY: {
                return new Class[]{JSONAware.class};
            }
            case ARRAY: {
                return new Class[]{JSONArray.class};
            }
            case OBJECT: {
                return new Class[]{JSONObject.class};
            }
        }
        throw new IllegalStateException("Unhandled output type: " + this.m_Type);
    }

    protected String doExecute() {
        String result = null;
        Object fileObj = this.m_InputToken.getPayload();
        File file = fileObj instanceof File ? (File)fileObj : new PlaceholderFile((String)fileObj);
        try {
            Object obj = JsonHelper.parse(file.getAbsoluteFile(), (LoggingSupporter)this);
            if (obj != null) {
                switch (this.m_Type) {
                    case ANY: {
                        this.m_OutputToken = new Token(obj);
                        break;
                    }
                    case ARRAY: {
                        this.m_OutputToken = new Token((Object)((JSONArray)obj));
                        break;
                    }
                    case OBJECT: {
                        this.m_OutputToken = new Token((Object)((JSONObject)obj));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled output type: " + this.m_Type);
                    }
                }
            }
        }
        catch (Exception e) {
            result = this.handleException("Failed to read JSON file: " + file, e);
        }
        return result;
    }
}

