/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.Utils;
import adams.core.logging.LoggingSupporter;
import adams.data.json.JsonHelper;
import adams.gui.core.TextEditorPanel;
import adams.gui.tools.previewbrowser.AbstractContentHandler;
import adams.gui.tools.previewbrowser.PreviewPanel;
import java.io.File;
import javax.swing.JComponent;

public class JsonPrettyPrintHandler
extends AbstractContentHandler {
    private static final long serialVersionUID = -5643331918040646266L;

    public String globalInfo() {
        return "Displays JSON files in pretty print format: " + Utils.arrayToString((Object)this.getExtensions());
    }

    public String[] getExtensions() {
        return new String[]{"json"};
    }

    public PreviewPanel createPreview(File file) {
        PreviewPanel result;
        try {
            Object obj = JsonHelper.parse(file.getAbsoluteFile(), (LoggingSupporter)this);
            if (obj == null) {
                throw new IllegalStateException("Failed to parse file as JSON: " + file);
            }
            String content = JsonHelper.prettyPrint(obj.toString());
            TextEditorPanel textPanel = new TextEditorPanel();
            textPanel.setContent(content);
            textPanel.setEditable(false);
            result = new PreviewPanel((JComponent)textPanel, (JComponent)textPanel.getTextArea());
        }
        catch (Exception e) {
            TextEditorPanel textPanel = new TextEditorPanel();
            textPanel.open(file);
            textPanel.setEditable(false);
            result = new PreviewPanel((JComponent)textPanel, (JComponent)textPanel.getTextArea());
        }
        return result;
    }
}

