/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.tools.previewbrowser;

import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.gui.core.TextEditorPanel;
import adams.gui.core.json.JsonTreeWithPreview;
import adams.gui.tools.previewbrowser.AbstractContentHandler;
import adams.gui.tools.previewbrowser.PreviewPanel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import javax.swing.JComponent;
import net.minidev.json.JSONAware;
import net.minidev.json.parser.JSONParser;

public class JsonTreeViewHandler
extends AbstractContentHandler {
    private static final long serialVersionUID = -5643331918040646266L;

    public String globalInfo() {
        return "Displays JSON files as hierarchical tree: " + Utils.arrayToString((Object)this.getExtensions());
    }

    public String[] getExtensions() {
        return new String[]{"json"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreviewPanel createPreview(File file) {
        PreviewPanel result;
        FileReader freader = null;
        BufferedReader breader = null;
        try {
            freader = new FileReader(file.getAbsolutePath());
            breader = new BufferedReader(freader);
            JSONParser parser = new JSONParser(1984);
            Object obj = parser.parse((Reader)breader);
            if (obj == null) {
                throw new IllegalStateException("Failed to parse: " + file);
            }
            if (!(obj instanceof JSONAware)) {
                throw new IllegalStateException("Cannot display: " + obj.getClass().getName());
            }
            JsonTreeWithPreview jsonPanel = new JsonTreeWithPreview();
            jsonPanel.setJSON((JSONAware)obj);
            jsonPanel.getTree().expandAll();
            result = new PreviewPanel((JComponent)((Object)jsonPanel));
        }
        catch (Exception e) {
            try {
                TextEditorPanel textPanel = new TextEditorPanel();
                textPanel.open(file);
                textPanel.setEditable(false);
                result = new PreviewPanel((JComponent)textPanel, (JComponent)textPanel.getTextArea());
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(breader);
                FileUtils.closeQuietly((Reader)freader);
                throw throwable;
            }
            FileUtils.closeQuietly((Reader)breader);
            FileUtils.closeQuietly((Reader)freader);
        }
        FileUtils.closeQuietly((Reader)breader);
        FileUtils.closeQuietly((Reader)freader);
        return result;
    }
}

