/*
 * Decompiled with CFR 0.152.
 */
package adams.data.outlier;

import adams.core.scripting.JythonScript;
import adams.data.container.DataContainer;
import adams.data.outlier.AbstractOutlierDetector;
import adams.data.outlier.AbstractScriptedOutlierDetector;
import java.util.List;

public class Jython
extends AbstractScriptedOutlierDetector {
    private static final long serialVersionUID = 1304903578667689350L;
    protected transient AbstractOutlierDetector m_OutlierDetectorObject;
    protected JythonScript m_InlineScript;

    public String globalInfo() {
        return "An outlier detector that uses a Jython script for processing the data.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("inline-script", "inlineScript", (Object)this.getDefaultInlineScript());
    }

    public String scriptOptionsTipText() {
        return "The options for the Jython script; must consist of 'key=value' pairs separated by blanks; the value of 'key' can be accessed via the 'getAdditionalOptions().getXYZ(\"key\")' method in the Jython actor.";
    }

    protected JythonScript getDefaultInlineScript() {
        return new JythonScript();
    }

    public void setInlineScript(JythonScript value) {
        this.m_InlineScript = value;
        this.reset();
    }

    public JythonScript getInlineScript() {
        return this.m_InlineScript;
    }

    public String inlineScriptTipText() {
        return "The inline script, if not using an external script file.";
    }

    protected String loadScriptObject() {
        Object[] result = adams.core.scripting.Jython.getSingleton().loadScriptObject(AbstractOutlierDetector.class, this.m_ScriptFile, this.m_InlineScript, this.m_ScriptOptions, this.getOptionManager().getVariables());
        this.m_ScriptObject = result[1];
        return (String)result[0];
    }

    protected String checkScriptObject() {
        return null;
    }

    protected void checkData(DataContainer data) {
        super.checkData(data);
        this.m_OutlierDetectorObject = (AbstractOutlierDetector)this.m_ScriptObject;
    }

    protected List<String> processData(DataContainer data) {
        return this.m_OutlierDetectorObject.detect(data);
    }

    public void destroy() {
        super.destroy();
        this.m_OutlierDetectorObject = null;
    }
}

