/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.Shortening;
import adams.core.option.OptionHandler;
import adams.core.scripting.JythonScript;
import adams.data.conversion.AbstractConversion;
import adams.data.conversion.AbstractScriptedConversion;

public class Jython
extends AbstractScriptedConversion {
    private static final long serialVersionUID = 3352831425650447531L;
    protected transient AbstractConversion m_ConversionObject;
    protected JythonScript m_InlineScript;

    public String globalInfo() {
        return "A conversion that uses a Jython script for processing the data.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("inline-script", "inlineScript", (Object)this.getDefaultInlineScript());
    }

    public String getQuickInfo() {
        if (QuickInfoHelper.hasVariable((OptionHandler)this, (String)"scriptFile") || !this.m_ScriptFile.isDirectory()) {
            return super.getQuickInfo();
        }
        return QuickInfoHelper.toString((OptionHandler)this, (String)"inlineScript", (Object)Shortening.shortenEnd((String)this.m_InlineScript.stringValue(), (int)50));
    }

    public String scriptOptionsTipText() {
        return "The options for the Jython script; must consist of 'key=value' pairs separated by blanks; the value of 'key' can be accessed via the 'getAdditionalOptions().getXYZ(\"key\")' method in the Jython actor.";
    }

    protected JythonScript getDefaultInlineScript() {
        return new JythonScript();
    }

    public void setInlineScript(JythonScript value) {
        this.m_InlineScript = value;
        this.reset();
    }

    public JythonScript getInlineScript() {
        return this.m_InlineScript;
    }

    public String inlineScriptTipText() {
        return "The inline script, if not using an external script file.";
    }

    public Class accepts() {
        if (this.m_ConversionObject != null) {
            return this.m_ConversionObject.accepts();
        }
        return Object.class;
    }

    public Class generates() {
        if (this.m_ConversionObject != null) {
            return this.m_ConversionObject.generates();
        }
        return Object.class;
    }

    protected String loadScriptObject() {
        Object[] result = adams.core.scripting.Jython.getSingleton().loadScriptObject(AbstractConversion.class, this.m_ScriptFile, this.m_InlineScript, this.m_ScriptOptions, this.getOptionManager().getVariables());
        this.m_ScriptObject = result[1];
        return (String)result[0];
    }

    protected String checkScriptObject() {
        return null;
    }

    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_ConversionObject = (AbstractConversion)this.m_ScriptObject;
        }
        return result;
    }

    protected Object doConvert() throws Exception {
        this.m_ConversionObject.setInput(this.m_Input);
        String msg = this.m_ConversionObject.convert();
        if (msg != null) {
            throw new IllegalStateException(msg);
        }
        return this.m_ConversionObject.getOutput();
    }

    public void destroy() {
        super.destroy();
        this.m_ConversionObject = null;
    }
}

