/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.output;

import adams.data.io.input.SpreadSheetReader;
import adams.data.io.output.AbstractMultiSheetFormattedSpreadSheetWriter;
import adams.data.spreadsheet.Cell;
import adams.data.spreadsheet.DataRow;
import adams.data.spreadsheet.SpreadSheet;
import java.io.Writer;
import java.util.logging.Level;

public class LatexSpreadSheetWriter
extends AbstractMultiSheetFormattedSpreadSheetWriter {
    private static final long serialVersionUID = 8693302523602090616L;

    public String globalInfo() {
        return "Generates LaTeX tables from spreadsheets.";
    }

    public String getFormatDescription() {
        return "LaTeX table output";
    }

    public String[] getFormatExtensions() {
        return new String[]{"tex"};
    }

    public SpreadSheetReader getCorrespondingReader() {
        return null;
    }

    protected boolean getUseOutputStream() {
        return false;
    }

    protected String escape(String s) {
        StringBuilder result = new StringBuilder();
        block4: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '_': 
                case '{': 
                case '}': {
                    result.append('\\');
                    result.append(c);
                    continue block4;
                }
                case '<': 
                case '>': {
                    result.append('$');
                    result.append(c);
                    result.append('$');
                    continue block4;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    protected boolean doWrite(SpreadSheet[] content, Writer writer) {
        boolean result = true;
        try {
            String newline = System.getProperty("line.separator");
            for (SpreadSheet cont : content) {
                Cell cell;
                int i;
                for (i = 0; i < cont.getComments().size(); ++i) {
                    writer.write("% " + (String)cont.getComments().get(i) + newline);
                }
                writer.write("\\begin{tabular}{|");
                for (i = 0; i < cont.getColumnCount(); ++i) {
                    if (cont.isNumeric(i)) {
                        writer.write("r|");
                        continue;
                    }
                    writer.write("l|");
                }
                writer.write("}" + newline);
                writer.write("  \\hline" + newline);
                boolean first = true;
                for (String key : cont.getHeaderRow().cellKeys()) {
                    cell = cont.getHeaderRow().getCell(key);
                    if (!first) {
                        writer.write(" & ");
                    } else {
                        writer.write("  ");
                    }
                    if (cell.isMissing()) {
                        writer.write(this.escape(this.m_MissingValue));
                    } else {
                        writer.write(this.escape(cell.getContent()));
                    }
                    first = false;
                }
                writer.write(" \\\\" + newline);
                for (DataRow row : cont.rows()) {
                    writer.write("  \\hline" + newline);
                    first = true;
                    for (String key : cont.getHeaderRow().cellKeys()) {
                        cell = row.getCell(key);
                        if (!first) {
                            writer.write(" & ");
                        } else {
                            writer.write("  ");
                        }
                        if (cell != null && cell.getContent() != null && !cell.isMissing()) {
                            if (cell.isNumeric()) {
                                writer.write(this.escape(this.format(cell.toDouble())));
                            } else {
                                writer.write(this.escape(cell.getContent()));
                            }
                        } else {
                            writer.write(this.escape(this.m_MissingValue));
                        }
                        first = false;
                    }
                    writer.write(" \\\\" + newline);
                }
                writer.write("  \\hline" + newline);
                writer.write("\\end{tabular}" + newline);
                writer.write(newline);
            }
        }
        catch (Exception e) {
            result = false;
            this.getLogger().log(Level.SEVERE, "Failed writing spreadsheet data", e);
        }
        return result;
    }
}

