/*
 * Decompiled with CFR 0.152.
 */
package adams.doc.latex.generator;

import adams.core.option.AbstractOptionHandler;
import adams.data.conversion.EscapeLatexCharacters;
import adams.doc.latex.generator.CodeGenerator;
import adams.flow.core.Actor;

public abstract class AbstractCodeGenerator
extends AbstractOptionHandler
implements CodeGenerator {
    private static final long serialVersionUID = -590133419718559795L;
    protected Actor m_FlowContext;
    protected boolean m_Skip;
    protected boolean m_NoVariableExpansion;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("skip", "skip", (Object)false);
        this.m_OptionManager.add("no-var-expansion", "noVariableExpansion", (Object)false);
    }

    @Override
    public void setSkip(boolean value) {
        this.m_Skip = value;
        this.reset();
    }

    @Override
    public boolean getSkip() {
        return this.m_Skip;
    }

    @Override
    public String skipTipText() {
        return "If enabled, the code generation gets skipped.";
    }

    @Override
    public void setNoVariableExpansion(boolean value) {
        this.m_NoVariableExpansion = value;
        this.reset();
    }

    @Override
    public boolean getNoVariableExpansion() {
        return this.m_NoVariableExpansion;
    }

    @Override
    public String noVariableExpansionTipText() {
        return "If enabled, variable expansion gets skipped.";
    }

    @Override
    public void setFlowContext(Actor value) {
        this.m_FlowContext = value;
    }

    @Override
    public Actor getFlowContext() {
        return this.m_FlowContext;
    }

    @Override
    public String getQuickInfo() {
        return null;
    }

    @Override
    public abstract String[] getRequiredPackages();

    @Override
    public String getAdditionalInformation() {
        String[] packages = this.getRequiredPackages();
        if (packages.length == 0) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        result.append("Required package(s):\n");
        for (String pkg : packages) {
            result.append("\\usepackage{" + pkg + "}\n");
        }
        return result.toString();
    }

    protected void check() {
        if (this.m_FlowContext == null && !this.m_NoVariableExpansion) {
            throw new IllegalStateException("No flow context set!");
        }
    }

    protected String escape(String s) {
        EscapeLatexCharacters conv = new EscapeLatexCharacters();
        conv.setCharacters(EscapeLatexCharacters.Characters.values());
        conv.setInput(s);
        conv.convert();
        return (String)conv.getOutput();
    }

    protected String expand(String s) {
        if (this.getNoVariableExpansion()) {
            return s;
        }
        if (this.m_FlowContext == null) {
            return s;
        }
        return this.m_FlowContext.getVariables().expand(s);
    }

    protected String expandEscape(String s) {
        return this.escape(this.expand(s));
    }

    protected String ensureTrailingNewLine(String s) {
        if (s.charAt(s.length() - 1) != '\n') {
            s = s + "\n";
        }
        return s;
    }

    protected void ensureTrailingNewLine(StringBuilder s) {
        if (s.charAt(s.length() - 1) != '\n') {
            s.append("\n");
        }
    }

    protected abstract String doGenerate();

    @Override
    public String generate() {
        if (this.getSkip()) {
            return "";
        }
        this.check();
        return this.doGenerate();
    }
}

