/*
 * Decompiled with CFR 0.152.
 */
package adams.doc.latex.generator;

import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.doc.latex.generator.AbstractFileReferencingCodeGenerator;

public class Image
extends AbstractFileReferencingCodeGenerator {
    private static final long serialVersionUID = 101642148012049382L;
    protected PlaceholderFile m_Image;
    protected String m_Options;

    public String globalInfo() {
        return "Inserts the specified image.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("image", "image", (Object)new PlaceholderFile());
        this.m_OptionManager.add("options", "options", (Object)"");
    }

    public void setImage(PlaceholderFile value) {
        this.m_Image = value;
        this.reset();
    }

    public PlaceholderFile getImage() {
        return this.m_Image;
    }

    public String imageTipText() {
        return "The image to insert.";
    }

    public void setOptions(String value) {
        this.m_Options = value;
        this.reset();
    }

    public String getOptions() {
        return this.m_Options;
    }

    public String optionsTipText() {
        return "The options (if any) for the image.";
    }

    @Override
    public String[] getRequiredPackages() {
        return new String[]{"graphicx"};
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"image", (Object)this.m_Image, (String)"image: ");
    }

    @Override
    protected String doGenerate() {
        StringBuilder result = new StringBuilder();
        result.append("\\includegraphics");
        if (!this.m_Options.isEmpty()) {
            result.append("[").append(this.m_Options).append("]");
        }
        result.append("{").append(this.processFile(this.m_Image)).append("}\n");
        return result.toString();
    }
}

