/*
 * Decompiled with CFR 0.152.
 */
package adams.doc.latex.generator;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.doc.latex.generator.AbstractMetaCodeGenerator;
import adams.doc.latex.generator.CodeGenerator;
import adams.doc.latex.generator.CustomStatements;
import adams.doc.latex.generator.Dummy;

public class MultiCol
extends AbstractMetaCodeGenerator {
    private static final long serialVersionUID = -2504232052630130162L;
    protected CodeGenerator m_Preface;
    protected int m_NumColumns;

    public String globalInfo() {
        return "Inserts a 'multicol' environment, providing multiple columns and an optional preface across the columns.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("preface", "preface", (Object)new Dummy());
        this.m_OptionManager.add("num-columns", "numColumns", (Object)2, (Number)1, null);
    }

    @Override
    protected CodeGenerator getDefaultGenerator() {
        return new CustomStatements();
    }

    @Override
    public String generatorTipText() {
        return "Generates the code for the columns.";
    }

    public void setPreface(CodeGenerator value) {
        this.m_Preface = value;
        this.reset();
    }

    public CodeGenerator getPreface() {
        return this.m_Preface;
    }

    public String prefaceTipText() {
        return "The optional code generator for the preface; use " + Dummy.class.getName() + " to skip.";
    }

    public void setNumColumns(int value) {
        if (this.getOptionManager().isValid("numColumns", (Number)value)) {
            this.m_NumColumns = value;
            this.reset();
        }
    }

    public int getNumColumns() {
        return this.m_NumColumns;
    }

    public String numColumnsTipText() {
        return "The number of columns to use.";
    }

    @Override
    public String[] getRequiredPackages() {
        return new String[]{"wrapfig"};
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"numColumns", (Object)this.m_NumColumns, (String)", #cols: ");
        return result;
    }

    @Override
    protected String doGenerate() {
        StringBuilder result = new StringBuilder();
        result.append("\\begin{multicols}{").append("" + this.m_NumColumns).append("}\n");
        if (!(this.m_Preface instanceof Dummy)) {
            result.append("[\n");
            result.append(this.m_Preface.generate());
            result.append("]\n");
        }
        result.append(this.m_Generator.generate());
        this.ensureTrailingNewLine(result);
        result.append("\\end{multicols}\n");
        return result.toString();
    }
}

