/*
 * Decompiled with CFR 0.152.
 */
package adams.doc.latex.generator;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.doc.latex.generator.AbstractMetaCodeGenerator;
import adams.doc.latex.generator.CodeGenerator;
import adams.doc.latex.generator.Verbatim;

public class BlockSize
extends AbstractMetaCodeGenerator {
    private static final long serialVersionUID = -2504232052630130162L;
    protected FontSize m_FontSize;

    public String globalInfo() {
        return "Inserts the code from the base generator inside a block with the specified font size.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("font-size", "fontSize", (Object)FontSize.normalsize);
    }

    @Override
    protected CodeGenerator getDefaultGenerator() {
        return new Verbatim();
    }

    @Override
    public String generatorTipText() {
        return "Generates the code for the differently sized block.";
    }

    public void setFontSize(FontSize value) {
        this.m_FontSize = value;
        this.reset();
    }

    public FontSize getFontSize() {
        return this.m_FontSize;
    }

    public String fontSizeTipText() {
        return "The font size to use for the encapsulated block.";
    }

    @Override
    public String[] getRequiredPackages() {
        return new String[0];
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"fontSize", (Object)((Object)this.m_FontSize), (String)"size: ");
    }

    @Override
    protected String doGenerate() {
        StringBuilder result = new StringBuilder();
        result.append("{\\").append(this.m_FontSize.toString()).append("\n");
        result.append(this.m_Generator.generate());
        this.ensureTrailingNewLine(result);
        result.append("}\n");
        return result.toString();
    }

    public static enum FontSize {
        tiny,
        scriptsize,
        footnotesize,
        small,
        normalsize,
        large,
        Large,
        LARGE,
        huge,
        Huge;

    }
}

