/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone;

import adams.core.io.PlaceholderDirectory;
import adams.doc.latex.LatexHelper;
import adams.flow.standalone.AbstractStandalone;
import java.io.File;

public class LatexSetup
extends AbstractStandalone {
    private static final long serialVersionUID = -1959430342987913960L;
    protected PlaceholderDirectory m_BinariesDir;
    protected String m_Executable;
    protected String m_ExecutableOptions;
    protected String m_Bibtex;

    public String globalInfo() {
        return "Allows to configure LaTex and override the system-wide settings.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("binaries-dir", "binariesDir", (Object)LatexHelper.getBinariesDir());
        this.m_OptionManager.add("executable", "executable", (Object)LatexHelper.getExecutable());
        this.m_OptionManager.add("executable-options", "executableOptions", (Object)LatexHelper.getExecutableOptions());
        this.m_OptionManager.add("bibtex", "bibtex", (Object)LatexHelper.getBibtex());
    }

    public void setBinariesDir(PlaceholderDirectory value) {
        this.m_BinariesDir = value;
        this.reset();
    }

    public PlaceholderDirectory getBinariesDir() {
        return this.m_BinariesDir;
    }

    public String binariesDirTipText() {
        return "The directory containing the LaTeX binaries.";
    }

    public void setExecutable(String value) {
        this.m_Executable = value;
        this.reset();
    }

    public String getExecutable() {
        return this.m_Executable;
    }

    public String executableTipText() {
        return "The executable to use (no path).";
    }

    public void setExecutableOptions(String value) {
        this.m_ExecutableOptions = value;
        this.reset();
    }

    public String getExecutableOptions() {
        return this.m_ExecutableOptions;
    }

    public String executableOptionsTipText() {
        return "The options for the executable to use.";
    }

    public void setBibtex(String value) {
        this.m_Bibtex = value;
        this.reset();
    }

    public String getBibtex() {
        return this.m_Bibtex;
    }

    public String bibtexTipText() {
        return "The bibtex executable to use (no path).";
    }

    public String executablePath(String exec) {
        return this.m_BinariesDir.getAbsolutePath() + File.separator + exec;
    }

    public String executablePath() {
        return this.executablePath(this.getExecutable());
    }

    public String bibtexPath() {
        return this.executablePath(this.getBibtex());
    }

    protected String doExecute() {
        if (!this.getBinariesDir().exists()) {
            return "LaTeX directory for binaries does not exist: " + this.m_BinariesDir;
        }
        return null;
    }
}

