/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.doc.latex.generator.CodeGenerator;
import adams.doc.latex.generator.CustomStatements;
import adams.flow.core.Actor;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;

public class LatexAppendDocument
extends AbstractTransformer {
    private static final long serialVersionUID = 8176319006728477554L;
    protected CodeGenerator m_Generator;

    public String globalInfo() {
        return "Appends the text generated from the specified LaTeX code generator.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("generator", "generator", (Object)new CustomStatements());
    }

    public void setGenerator(CodeGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public CodeGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The code generator to use for appending the document.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"generator", (Object)this.m_Generator, (String)"generator: ");
    }

    public Class[] accepts() {
        return new Class[]{String.class, StringBuilder.class};
    }

    public Class[] generates() {
        return new Class[]{StringBuilder.class};
    }

    protected String doExecute() {
        String result = null;
        try {
            StringBuilder doc = this.m_InputToken.getPayload() instanceof StringBuilder ? (StringBuilder)this.m_InputToken.getPayload() : new StringBuilder((String)this.m_InputToken.getPayload());
            this.m_Generator.setFlowContext((Actor)this);
            doc.append(this.m_Generator.generate());
            this.m_OutputToken = new Token((Object)doc);
        }
        catch (Exception e) {
            result = this.handleException("Failed to append document!", e);
        }
        return result;
    }
}

