/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.application;

import adams.core.Properties;
import adams.core.io.FileUtils;
import adams.doc.latex.LatexHelper;
import adams.env.Environment;
import adams.gui.application.AbstractPreferencesPanel;
import adams.gui.chooser.DirectoryChooserPanel;
import adams.gui.core.BaseTextField;
import adams.gui.core.ParameterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;

public class LatexSetupPanel
extends AbstractPreferencesPanel {
    private static final long serialVersionUID = -7937644706618374284L;
    protected ParameterPanel m_PanelParameters;
    protected DirectoryChooserPanel m_ChooserLatexBinaries;
    protected BaseTextField m_TextExecutable;
    protected BaseTextField m_TextExecutableOptions;
    protected BaseTextField m_TextBibtex;

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_PanelParameters = new ParameterPanel();
        this.add((Component)this.m_PanelParameters, "Center");
        this.m_ChooserLatexBinaries = new DirectoryChooserPanel();
        this.m_ChooserLatexBinaries.setCurrent((File)LatexHelper.getBinariesDir());
        this.m_PanelParameters.addParameter("_Binaries dir", (Component)this.m_ChooserLatexBinaries);
        this.m_TextExecutable = new BaseTextField(10);
        this.m_TextExecutable.setText(LatexHelper.getExecutable());
        this.m_PanelParameters.addParameter("_Executable", (Component)this.m_TextExecutable);
        this.m_TextExecutableOptions = new BaseTextField(10);
        this.m_TextExecutableOptions.setText(LatexHelper.getExecutableOptions());
        this.m_PanelParameters.addParameter("Executable _options", (Component)this.m_TextExecutableOptions);
        this.m_TextBibtex = new BaseTextField(10);
        this.m_TextBibtex.setText(LatexHelper.getBibtex());
        this.m_PanelParameters.addParameter("B_ibtex", (Component)this.m_TextBibtex);
    }

    protected Properties toProperties() {
        Properties result = new Properties();
        result.setProperty("BinariesDir", ((File)this.m_ChooserLatexBinaries.getCurrent()).getAbsolutePath());
        result.setProperty("Executable", this.m_TextExecutable.getText());
        result.setProperty("ExecutableOptions", this.m_TextExecutableOptions.getText());
        result.setProperty("Bibtex", this.m_TextBibtex.getText());
        return result;
    }

    public String getTitle() {
        return "Latex";
    }

    public boolean requiresWrapper() {
        return true;
    }

    public String activate() {
        boolean result = LatexHelper.writeProperties(this.toProperties());
        if (result) {
            return null;
        }
        return "Failed to save LaTeX setup to LaTeX.props!";
    }

    public boolean canReset() {
        String props = Environment.getInstance().getCustomPropertiesFilename("latex");
        return props != null && FileUtils.fileExists((String)props);
    }

    public String reset() {
        String props = Environment.getInstance().getCustomPropertiesFilename("latex");
        if (props != null && FileUtils.fileExists((String)props) && !FileUtils.delete((String)props)) {
            return "Failed to remove custom Latex properties: " + props;
        }
        return null;
    }
}

