/*
 * Decompiled with CFR 0.152.
 */
package adams.doc.latex.generator;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.doc.latex.generator.AbstractMetaCodeGeneratorWithNoTrailingSpace;
import adams.doc.latex.generator.CodeGenerator;
import adams.doc.latex.generator.Figure;

public class MiniPage
extends AbstractMetaCodeGeneratorWithNoTrailingSpace {
    private static final long serialVersionUID = -2504232052630130162L;
    protected String m_Position;
    protected String m_Width;

    public String globalInfo() {
        return "Inserts a minipage environment.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("position", "position", (Object)"");
        this.m_OptionManager.add("width", "width", (Object)"0.5\\linewidth");
    }

    @Override
    protected CodeGenerator getDefaultGenerator() {
        return new Figure();
    }

    @Override
    public String generatorTipText() {
        return "Generates the code for the minipage.";
    }

    public void setPosition(String value) {
        this.m_Position = value;
        this.reset();
    }

    public String getPosition() {
        return this.m_Position;
    }

    public String positionTipText() {
        return "The optional position parameter.";
    }

    public void setWidth(String value) {
        this.m_Width = value;
        this.reset();
    }

    public String getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width for the minipage.";
    }

    @Override
    public String[] getRequiredPackages() {
        return new String[]{"minipage"};
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"width", (Object)(this.m_Width.isEmpty() ? "-missing-" : this.m_Width), (String)", width: ");
        return result;
    }

    @Override
    protected void check() {
        super.check();
        if (this.m_Width.isEmpty()) {
            throw new IllegalStateException("No width provided!");
        }
    }

    @Override
    protected String doGenerate() {
        StringBuilder result = new StringBuilder();
        result.append("\\begin{minipage}");
        if (!this.m_Position.isEmpty()) {
            result.append("[").append(this.m_Position).append("]");
        }
        result.append("{").append(this.m_Width).append("}");
        result.append("\n");
        result.append("  ").append(this.m_Generator.generate());
        this.ensureTrailingNewLine(result);
        result.append("\\end{minipage}");
        if (this.m_SuppressTrailingSpace) {
            result.append("%");
        }
        result.append("\n");
        return result.toString();
    }
}

