/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.processor;

import adams.core.option.AbstractOption;
import adams.core.option.OptionTraversalPath;
import adams.doc.latex.generator.CodeGenerator;
import adams.flow.processor.AbstractListingProcessor;

public class ListRequiredLatexPackages
extends AbstractListingProcessor {
    private static final long serialVersionUID = -6340700367008421185L;
    protected boolean m_GenerateUsePackageStatements;

    public String globalInfo() {
        return "Generates a list of all the packages required by the " + CodeGenerator.class.getName() + "-derived LaTeX generators.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("generate-usepackage-statements", "generateUsePackageStatements", (Object)false);
    }

    public void setGenerateUsePackageStatements(boolean value) {
        this.m_GenerateUsePackageStatements = value;
        this.reset();
    }

    public boolean getGenerateUsePackageStatements() {
        return this.m_GenerateUsePackageStatements;
    }

    public String generateUsePackageStatementsTipText() {
        return "If enabled, generates 'usepackage' LaTeX statements.";
    }

    public String getTitle() {
        return "Required LaTeX packages";
    }

    protected boolean isValid(AbstractOption option, Object obj, OptionTraversalPath path) {
        return obj instanceof CodeGenerator;
    }

    protected String[] objectToStrings(AbstractOption option, Object obj, OptionTraversalPath path) {
        String[] result = ((CodeGenerator)obj).getRequiredPackages();
        if (this.m_GenerateUsePackageStatements) {
            for (int i = 0; i < result.length; ++i) {
                result[i] = "\\usepackage{" + result[i] + "}";
            }
        }
        return result;
    }

    protected boolean generatesMultipleItems() {
        return true;
    }

    protected boolean isSortedList() {
        return true;
    }

    protected boolean isUniqueList() {
        return true;
    }

    protected String getHeader() {
        return "Required LaTeX packages:";
    }
}

