/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseText;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.source.AbstractSimpleSource;

public class NewLatexDocument
extends AbstractSimpleSource {
    private static final long serialVersionUID = 1277901907777271692L;
    protected BaseText m_Prolog;
    protected String m_DocumentClass;
    protected String m_DocumentClassOptions;
    protected BaseText m_AdditionalStatements;

    public String globalInfo() {
        return "Creates a new LaTeX document.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("prolog", "prolog", (Object)new BaseText());
        this.m_OptionManager.add("document-class", "documentClass", (Object)"article");
        this.m_OptionManager.add("document-class-options", "documentClassOptions", (Object)"a4paper");
        this.m_OptionManager.add("additional-statements", "additionalStatements", (Object)new BaseText());
    }

    public void setProlog(BaseText value) {
        this.m_Prolog = value;
        this.reset();
    }

    public BaseText getProlog() {
        return this.m_Prolog;
    }

    public String prologTipText() {
        return "The (optional) prolog to insert as comments before the document starts.";
    }

    public void setDocumentClass(String value) {
        this.m_DocumentClass = value;
        this.reset();
    }

    public String getDocumentClass() {
        return this.m_DocumentClass;
    }

    public String documentClassTipText() {
        return "The document class to use for the document.";
    }

    public void setDocumentClassOptions(String value) {
        this.m_DocumentClassOptions = value;
        this.reset();
    }

    public String getDocumentClassOptions() {
        return this.m_DocumentClassOptions;
    }

    public String documentClassOptionsTipText() {
        return "The options (if any) for the document class.";
    }

    public void setAdditionalStatements(BaseText value) {
        this.m_AdditionalStatements = value;
        this.reset();
    }

    public BaseText getAdditionalStatements() {
        return this.m_AdditionalStatements;
    }

    public String additionalStatementsTipText() {
        return "The additional statements (eg include or usepackage) to insert.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"documentClass", (Object)this.m_DocumentClass, (String)"class: ");
    }

    public Class[] generates() {
        return new Class[]{StringBuilder.class};
    }

    protected String doExecute() {
        String[] lines;
        StringBuilder doc = new StringBuilder();
        if (!this.m_Prolog.isEmpty()) {
            for (String line : lines = this.m_Prolog.getValue().split("\n")) {
                doc.append("% ");
                doc.append(line);
                doc.append("\n");
            }
            doc.append("\n");
        }
        doc.append("\\documentclass");
        if (!this.m_DocumentClassOptions.isEmpty()) {
            doc.append("[").append(this.m_DocumentClassOptions).append("]");
        }
        doc.append("{").append(this.m_DocumentClass).append("}\n");
        doc.append("\n");
        if (!this.m_AdditionalStatements.isEmpty()) {
            for (String line : lines = this.m_AdditionalStatements.getValue().split("\n")) {
                doc.append(line);
                doc.append("\n");
            }
            doc.append("\n");
        }
        doc.append("\\begin{document}\n");
        doc.append("\n");
        this.m_OutputToken = new Token((Object)doc);
        return null;
    }
}

