/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.Utils;
import adams.data.conversion.AbstractStringConversion;
import gnu.trove.list.array.TCharArrayList;
import java.util.ArrayList;

public class EscapeLatexCharacters
extends AbstractStringConversion {
    private static final long serialVersionUID = -8987744505136943381L;
    protected Characters[] m_Characters;

    public String globalInfo() {
        return "Turns the selected characters into their LaTeX representation.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("character", "characters", (Object)new Characters[0]);
    }

    public void setCharacters(Characters[] value) {
        this.m_Characters = value;
        this.reset();
    }

    public Characters[] getCharacters() {
        return this.m_Characters;
    }

    public String charactersTipText() {
        return "The characters to escape.";
    }

    protected Object doConvert() throws Exception {
        String input = (String)this.m_Input;
        TCharArrayList chars = new TCharArrayList();
        ArrayList<String> escaped = new ArrayList<String>();
        block8: for (Characters ch : this.m_Characters) {
            switch (ch) {
                case AMPERSAND: {
                    chars.add('&');
                    escaped.add("\\&");
                    continue block8;
                }
                case BACKSLASH: {
                    chars.add('\\');
                    escaped.add("\\textbackslash ");
                    continue block8;
                }
                case DOLLAR: {
                    chars.add('$');
                    escaped.add("\\$");
                    continue block8;
                }
                case UNDERSCORE: {
                    chars.add('_');
                    escaped.add("\\_");
                    continue block8;
                }
                case CARET: {
                    chars.add('^');
                    escaped.add("$^\\wedge$");
                    continue block8;
                }
                case PERCENTAGE: {
                    chars.add('%');
                    escaped.add("\\%");
                    continue block8;
                }
                default: {
                    throw new IllegalStateException("Unhandled character: " + ch);
                }
            }
        }
        String result = Utils.backQuoteChars((String)input, (char[])chars.toArray(), (String[])escaped.toArray(new String[escaped.size()]));
        return result;
    }

    public static enum Characters {
        BACKSLASH,
        PERCENTAGE,
        UNDERSCORE,
        DOLLAR,
        AMPERSAND,
        CARET;

    }
}

