/*
 * Decompiled with CFR 0.152.
 */
package adams.doc.latex;

import adams.core.Properties;
import adams.core.io.PlaceholderDirectory;
import adams.core.management.OS;
import adams.env.Environment;

public class LatexHelper {
    public static final String FILENAME = "LaTeX.props";
    public static final String BINARIES_DIR = "BinariesDir";
    public static final String EXECUTABLE = "Executable";
    public static final String EXECUTABLE_OPTIONS = "ExecutableOptions";
    public static final String BIBTEX = "Bibtex";
    protected static Properties m_Properties;

    public static synchronized Properties getProperties() {
        if (m_Properties == null) {
            try {
                m_Properties = Environment.getInstance().read("latex");
            }
            catch (Exception e) {
                m_Properties = new Properties();
            }
        }
        return m_Properties;
    }

    public static synchronized boolean writeProperties() {
        return LatexHelper.writeProperties(LatexHelper.getProperties());
    }

    public static synchronized boolean writeProperties(Properties props) {
        boolean result = Environment.getInstance().write("latex", props);
        m_Properties = null;
        return result;
    }

    public static PlaceholderDirectory getBinariesDir() {
        String defPath = OS.isLinux() ? "/usr/bin" : ".";
        return new PlaceholderDirectory(LatexHelper.getProperties().getPath(BINARIES_DIR, defPath));
    }

    public static String getExecutable() {
        String defExec = OS.isWindows() ? "pdflatex.exe" : "pdflatex";
        return LatexHelper.getProperties().getProperty(EXECUTABLE, defExec);
    }

    public static String getExecutableOptions() {
        return LatexHelper.getProperties().getProperty(EXECUTABLE_OPTIONS, "");
    }

    public static String getBibtex() {
        String defExec = OS.isWindows() ? "bibtex.exe" : "bibtex";
        return LatexHelper.getProperties().getProperty(EXECUTABLE, defExec);
    }
}

