/*
 * Decompiled with CFR 0.152.
 */
package adams.doc.latex.generator;

import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.doc.latex.generator.AbstractCodeGenerator;
import java.io.File;

public abstract class AbstractFileReferencingCodeGenerator
extends AbstractCodeGenerator {
    private static final long serialVersionUID = -2904853840565190465L;
    protected PathType m_PathType;
    protected String m_SuppliedDir;
    protected boolean m_RemoveExtension;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("path-type", "pathType", (Object)this.getDefaultPathType());
        this.m_OptionManager.add("supplied-dir", "suppliedDir", (Object)this.getDefaultSuppliedDir());
        this.m_OptionManager.add("remove-extension", "removeExtension", (Object)this.getDefaultRemoveExtension());
    }

    protected PathType getDefaultPathType() {
        return PathType.ABSOLUTE;
    }

    public void setPathType(PathType value) {
        this.m_PathType = value;
        this.reset();
    }

    public PathType getPathType() {
        return this.m_PathType;
    }

    public String pathTypeTipText() {
        return "Determines how to process the file name.";
    }

    protected String getDefaultSuppliedDir() {
        return "";
    }

    public void setSuppliedDir(String value) {
        this.m_SuppliedDir = value;
        this.reset();
    }

    public String getSuppliedDir() {
        return this.m_SuppliedDir;
    }

    public String suppliedDirTipText() {
        return "The directory name to use instead.";
    }

    protected boolean getDefaultRemoveExtension() {
        return false;
    }

    public void setRemoveExtension(boolean value) {
        this.m_RemoveExtension = value;
        this.reset();
    }

    public boolean getRemoveExtension() {
        return this.m_RemoveExtension;
    }

    public String removeExtensionTipText() {
        return "If enabled, removes the extension from the filename.";
    }

    protected String processFile(PlaceholderFile file) {
        Object result;
        switch (this.m_PathType) {
            case ABSOLUTE: {
                result = file.getAbsolutePath();
                break;
            }
            case BASENAME: {
                result = file.getName();
                break;
            }
            case SUPPLIED_DIR: {
                result = this.m_SuppliedDir + (this.m_SuppliedDir.endsWith(File.separator) ? "" : File.separator) + file.getName();
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled path type: " + this.m_PathType);
            }
        }
        if (this.m_RemoveExtension) {
            result = FileUtils.replaceExtension((String)result, (String)"");
        }
        return result;
    }

    public static enum PathType {
        ABSOLUTE,
        BASENAME,
        SUPPLIED_DIR;

    }
}

