/*
 * Decompiled with CFR 0.152.
 */
package adams.doc.latex.generator;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.doc.latex.generator.AbstractMetaCodeGenerator;
import adams.doc.latex.generator.CodeGenerator;
import adams.doc.latex.generator.Image;

public class Figure
extends AbstractMetaCodeGenerator {
    private static final long serialVersionUID = -2504232052630130162L;
    protected String m_Options;
    protected boolean m_Center;
    protected String m_Caption;
    protected String m_Label;

    public String globalInfo() {
        return "Inserts a figure with the code generated by the base generator.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("options", "options", (Object)"");
        this.m_OptionManager.add("center", "center", (Object)false);
        this.m_OptionManager.add("caption", "caption", (Object)"");
        this.m_OptionManager.add("label", "label", (Object)"");
    }

    @Override
    protected CodeGenerator getDefaultGenerator() {
        return new Image();
    }

    @Override
    public String generatorTipText() {
        return "Generates the code for the figure.";
    }

    public void setOptions(String value) {
        this.m_Options = value;
        this.reset();
    }

    public String getOptions() {
        return this.m_Options;
    }

    public String optionsTipText() {
        return "The options for the figure.";
    }

    public void setCenter(boolean value) {
        this.m_Center = value;
        this.reset();
    }

    public boolean getCenter() {
        return this.m_Center;
    }

    public String centerTipText() {
        return "Whether to center the figure.";
    }

    public void setCaption(String value) {
        this.m_Caption = value;
        this.reset();
    }

    public String getCaption() {
        return this.m_Caption;
    }

    public String captionTipText() {
        return "The caption of the figure.";
    }

    public void setLabel(String value) {
        this.m_Label = value;
        this.reset();
    }

    public String getLabel() {
        return this.m_Label;
    }

    public String labelTipText() {
        return "The optional label of the figure (for cross-referencing).";
    }

    @Override
    public String[] getRequiredPackages() {
        return new String[]{"wrapfig"};
    }

    @Override
    public String getQuickInfo() {
        Object result = super.getQuickInfo();
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"caption", (Object)(this.m_Caption.isEmpty() ? "-no caption-" : this.m_Caption), (String)", caption: ");
        return result;
    }

    @Override
    protected String doGenerate() {
        StringBuilder result = new StringBuilder();
        result.append("\\begin{figure}");
        if (!this.m_Options.isEmpty()) {
            result.append("[").append(this.m_Options).append("]");
        }
        result.append("\n");
        if (this.m_Center) {
            result.append("  \\centering\n");
        }
        result.append("  ").append(this.m_Generator.generate());
        this.ensureTrailingNewLine(result);
        if (!this.m_Caption.isEmpty()) {
            result.append("  \\caption{").append(this.expandEscape(this.m_Caption)).append("}\n");
        }
        if (!this.m_Label.isEmpty()) {
            result.append("  \\label{").append(this.expand(this.m_Label)).append("}\n");
        }
        result.append("\\end{figure}\n");
        return result.toString();
    }
}

