/*
 * Decompiled with CFR 0.152.
 */
package adams.doc.latex.generator;

import adams.core.QuickInfoHelper;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.doc.latex.generator.AbstractCodeGenerator;
import java.io.File;
import java.util.List;

public class ImportContent
extends AbstractCodeGenerator {
    private static final long serialVersionUID = 101642148012049382L;
    protected PlaceholderFile m_Import;
    protected boolean m_Escape;

    public String globalInfo() {
        return "Imports the content of the specified file. By default, the content gets escaped to make it valid LaTeX.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("import", "import", (Object)new PlaceholderFile());
        this.m_OptionManager.add("escape", "escape", (Object)true);
    }

    public void setImport(PlaceholderFile value) {
        this.m_Import = value;
        this.reset();
    }

    public PlaceholderFile getImport() {
        return this.m_Import;
    }

    public String importTipText() {
        return "The file to import the content from.";
    }

    public void setEscape(boolean value) {
        this.m_Escape = value;
        this.reset();
    }

    public boolean getEscape() {
        return this.m_Escape;
    }

    public String escapeTipText() {
        return "If enabled, the content of the import file get escaped to make it valid LaTeX.";
    }

    @Override
    public String[] getRequiredPackages() {
        return new String[0];
    }

    @Override
    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"import", (Object)this.m_Import, (String)"import: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"escape", (Object)(this.m_Escape ? "escaped" : "unescaped"));
        return result;
    }

    @Override
    protected String doGenerate() {
        StringBuilder result = new StringBuilder();
        List lines = FileUtils.loadFromFile((File)this.m_Import);
        for (String line : lines) {
            if (this.m_Escape) {
                line = this.escape(line);
            }
            result.append(line);
            result.append("\n");
        }
        return result.toString();
    }
}

