/*
 * Decompiled with CFR 0.152.
 */
package adams.doc.latex.generator;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.doc.latex.generator.AbstractCodeGenerator;

public class NewSection
extends AbstractCodeGenerator {
    private static final long serialVersionUID = 7225514457280622837L;
    protected PageAction m_PageAction;
    protected SectionType m_Type;
    protected String m_Title;
    protected String m_Label;

    public String globalInfo() {
        return "Adds a new section to the document with an optional label for cross-referencing.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("page-action", "pageAction", (Object)PageAction.NONE);
        this.m_OptionManager.add("type", "type", (Object)SectionType.SECTION);
        this.m_OptionManager.add("title", "title", (Object)"");
        this.m_OptionManager.add("label", "label", (Object)"");
    }

    public void setPageAction(PageAction value) {
        this.m_PageAction = value;
        this.reset();
    }

    public PageAction getPageAction() {
        return this.m_PageAction;
    }

    public String pageActionTipText() {
        return "The page action to insert.";
    }

    public void setType(SectionType value) {
        this.m_Type = value;
        this.reset();
    }

    public SectionType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of the section.";
    }

    public void setTitle(String value) {
        this.m_Title = value;
        this.reset();
    }

    public String getTitle() {
        return this.m_Title;
    }

    public String titleTipText() {
        return "The title of the section.";
    }

    public void setLabel(String value) {
        this.m_Label = value;
        this.reset();
    }

    public String getLabel() {
        return this.m_Label;
    }

    public String labelTipText() {
        return "The optional label of the section (for cross-referencing).";
    }

    @Override
    public String[] getRequiredPackages() {
        return new String[0];
    }

    @Override
    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"pageAction", (Object)((Object)this.m_PageAction), (String)"page: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)((Object)this.m_Type), (String)", type: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"title", (Object)(this.m_Title.isEmpty() ? "-no title-" : this.m_Title), (String)", title: ");
        return result;
    }

    @Override
    protected String doGenerate() {
        StringBuilder result = new StringBuilder("\n");
        if (this.m_PageAction != PageAction.NONE) {
            result.append("\\").append(this.m_PageAction.toString().toLowerCase()).append("\n");
        }
        result.append("\\").append(this.m_Type.toString().toLowerCase()).append("{");
        result.append(this.expandEscape(this.m_Title));
        result.append("}\n");
        if (!this.m_Label.isEmpty()) {
            result.append("\\label{").append(this.expand(this.m_Label)).append("}\n");
        }
        result.append("\n");
        return result.toString();
    }

    public static enum SectionType {
        PART,
        CHAPTER,
        SECTION,
        SUBSECTION,
        SUBSUBSECTION,
        PARAGRAPH,
        SUBPARAGRAPH;

    }

    public static enum PageAction {
        NONE,
        NEWPAGE,
        CLEARPAGE;

    }
}

