/*
 * Decompiled with CFR 0.152.
 */
package adams.doc.latex.generator;

import adams.core.QuickInfoHelper;
import adams.core.management.LocaleHelper;
import adams.core.option.OptionHandler;
import adams.data.io.output.LatexSpreadSheetWriter;
import adams.data.spreadsheet.SpreadSheet;
import adams.doc.latex.generator.AbstractCodeGenerator;
import adams.flow.control.StorageName;
import adams.flow.control.StorageUser;
import java.io.StringWriter;
import java.util.Locale;

public class Table
extends AbstractCodeGenerator
implements StorageUser {
    private static final long serialVersionUID = -2504232052630130162L;
    protected StorageName m_StorageName;
    protected String m_MissingValue;
    protected Locale m_Locale;
    protected String m_NumberFormat;

    public String globalInfo() {
        return "Inserts the spreadsheet obtained from storage as table.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("storage-name", "storageName", (Object)new StorageName("table"));
        this.m_OptionManager.add("missing", "missingValue", (Object)this.getDefaultMissingValue());
        this.m_OptionManager.add("locale", "locale", (Object)LocaleHelper.getSingleton().getDefault());
        this.m_OptionManager.add("number-format", "numberFormat", (Object)this.getDefaultNumberFormat());
    }

    public void setStorageName(StorageName value) {
        this.m_StorageName = value;
        this.reset();
    }

    public StorageName getStorageName() {
        return this.m_StorageName;
    }

    public String storageNameTipText() {
        return "The name for the lookup table in the internal storage.";
    }

    protected String getDefaultMissingValue() {
        return "";
    }

    public void setMissingValue(String value) {
        this.m_MissingValue = value;
        this.reset();
    }

    public String getMissingValue() {
        return this.m_MissingValue;
    }

    public String missingValueTipText() {
        return "The placeholder for missing values.";
    }

    public void setLocale(Locale value) {
        this.m_Locale = value;
        this.reset();
    }

    public Locale getLocale() {
        return this.m_Locale;
    }

    public String localeTipText() {
        return "The locale to use for formatting the numbers.";
    }

    protected String getDefaultNumberFormat() {
        return "";
    }

    public void setNumberFormat(String value) {
        this.m_NumberFormat = value;
        this.reset();
    }

    public String getNumberFormat() {
        return this.m_NumberFormat;
    }

    public String numberFormatTipText() {
        return "The format for the numbers (see java.text.DecimalFormat), use empty string for default 'double' output.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"storageName", (Object)this.m_StorageName, (String)"storage: ");
    }

    public boolean isUsingStorage() {
        return !this.getSkip();
    }

    @Override
    public String[] getRequiredPackages() {
        return new String[0];
    }

    @Override
    protected String doGenerate() {
        SpreadSheet sheet = (SpreadSheet)this.getFlowContext().getStorageHandler().getStorage().get(this.m_StorageName);
        StringWriter swriter = new StringWriter();
        LatexSpreadSheetWriter lwriter = new LatexSpreadSheetWriter();
        lwriter.setMissingValue(this.m_MissingValue);
        lwriter.setLocale(this.m_Locale);
        lwriter.setNumberFormat(this.m_NumberFormat);
        lwriter.write(sheet, swriter);
        return swriter.toString();
    }
}

